package com.elitesland.yst.production.inv.base;

import com.elitescloud.boot.model.entity.BaseModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 基础Service，包含一些通用的方法
 *
 * @author sushiqi
 * @date 2022/4/20
 */
public interface BaseService<E extends BaseModel, ID extends Serializable> {
    @Autowired
    BaseRepo<E, ID> getDao();

    default E save(E entity) {
        return getDao().save(entity);
    }

    default Iterable<E> saveAll(Iterable<E> entities) {
        return getDao().saveAll(entities);
    }


    default E saveAndFlush(E entity) {

        return getDao().saveAndFlush(entity);
    }

    default E update(E entity) {

        return getDao().saveAndFlush(entity);
    }

    default void delete(ID id) {
        if (getDao().existsById(id)) {
            getDao().deleteById(id);
        }
    }


    default void delete(E entity) {
        getDao().delete(entity);
    }

    /**
     * 此方法有性能问题，小批量删除可引用
     * @param entity
     */
    default void deleteByCondition(E entity) {
        Example<E> eExample = Example.of(entity);
        int current = 1;
        Pageable pageable = PageRequest.of(current - 1, 500);
        while (true){
            Page<E> all = getDao().findAll(eExample, pageable);
            if(CollectionUtils.isEmpty(all.getContent())){
                break;
            }
            getDao().deleteAll(all);
            current++;
            if (all.getContent().size() < 500) {
                break;
            }
        }
    }
    default long count() {
        return getDao().count();
    }

    default long count(Specification<E> specification) {
        return getDao().count(specification);
    }

    default List<E> findAll() {
        return getDao().findAll();
    }

    default List<E> findAll(Example<E> example) {

        return getDao().findAll(example);
    }
    default E findOne(Example<E> example) {
        return getDao().findOne(example).orElse(null);
    }


    default E findById(ID id) {
        return getDao().findById(id).orElse(null);
    }

    default Page<E> findAll(Pageable pageable) {
        return getDao().findAll(pageable);
    }

    default Page<E> findAll(Specification<E> specification, Pageable pageable) {
        return getDao().findAll(specification, pageable);
    }

    default void flush() {
        getDao().flush();
    }
}
