package com.elitesland.yst.production.inv.domain.entity.carr;


import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author feng
 * @program: yst-inv
 * @description: 配送单附件
 * @date 2021-10-13 17:05:33
 */
@Entity
@Table(name = "inv_carr_file")
@DynamicInsert
@org.hibernate.annotations.Table(appliesTo = "inv_carr_file", comment = "承运商配送单文件")
@Data
@Accessors(chain = true)
@ApiModel(value = "inv_carr_file", description = "承运商配送单文件")
public class InvCarrFileDO extends BaseModel implements Serializable {


    private static final long serialVersionUID = 5870812220060663485L;
    @ApiModelProperty("主表ID")
    @Column(name="mas_id" , columnDefinition = "bigint default 0  comment '主表ID'")
    private Long masId;
    @ApiModelProperty("凭证类型UDC[PUR:CP_DOCUMENT_TYPE]")
    @Column(name="document_type" , columnDefinition = "varchar(20)  comment '凭证类型UDC[PUR:CP_DOCUMENT_TYPE]'")
    private String documentType;
    @ApiModelProperty("文件code")
    @Column(name="file_code" , columnDefinition = "varchar(2000)  comment '文件code,多个逗号分隔'")
    private String fileCode;
}
