package com.elitesland.yst.production.inv.domain.entity.invtrn;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.boot.model.entity.BaseModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class InvTrnD extends BaseModel implements Serializable {

    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long masId;

    @ApiModelProperty("行号")
    Double lineNo;;

    @ApiModelProperty("行状态")
    String lineStatus;

    @ApiModelProperty("行类型")
    String lineType;

    @ApiModelProperty("从公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long oOuId;

    @ApiModelProperty("从仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long oWhId;

    @ApiModelProperty("从仓库code")
    String oWhCode;

    @ApiModelProperty("从温层 [UDC]INV:TEMP_TYPE")
    String oDeter1;

    @ApiModelProperty("从功能区 [UDC]INV:FUNC_TYPE")
    @NotNull
    String oDeter2;

    @ApiModelProperty("在途功能区[UDC]INV:FUNC_TYPE")
    String tranDeter3;
    String tranDeter3Name;

    @ApiModelProperty("从客户标识")
    String oDeter3;

    @ApiModelProperty("从限定4")
    String oDeter4;


    @ApiModelProperty("到公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long iOuId;

    @ApiModelProperty("到仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long iWhId;

    @ApiModelProperty("到仓库code")
    String iWhCode;

    @ApiModelProperty("到温层 [UDC]INV:TEMP_TYPE")
    String iDeter1;

    @ApiModelProperty("到功能区 [UDC]INV:FUNC_TYPE")
    @NotNull
    String iDeter2;

    @ApiModelProperty("到客户标识")
    String iDeter3;

    @ApiModelProperty("到限定4")
    String iDeter4;

    @ApiModelProperty("品项ID")
    @NotNull
    @JsonSerialize(using = ToStringSerializer.class)
    Long itemId;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long variId;

    @ApiModelProperty("批次")
    String lotNo;

    @ApiModelProperty("序列号")
    String snNo;

    @ApiModelProperty("单位")
    String uom;

    @ApiModelProperty("单位转换率")
    Float uomRatio;

    @ApiModelProperty("总数量")
    @NotNull
    BigDecimal qty;

    @ApiModelProperty("数量单位")
    String qtyUom;

    @ApiModelProperty("成本金额")
    BigDecimal costAmt;

    @ApiModelProperty("关联单据类别 如RMA。[UDC]COM:DOC_CLS")
    @SysCode(sys = "COM", mod = "DOC_CLS")
    String relateDocCls;
    String relateDocClsName;

    @ApiModelProperty("关联单据类型")
    String relateDocType;

    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long relateDocId;

    @ApiModelProperty("关联单据编号")
    String relateDocNo;

    @ApiModelProperty("关联单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long relateDocDid;

    @ApiModelProperty("关联单据行号")
    Float relateDocLineno;

    @ApiModelProperty("从合作伙伴类型")
    String oPType;

    @ApiModelProperty("从合作伙伴编码")
    String oPCode;
    String oPName;

    @ApiModelProperty("至合作伙伴类型")
    String iPType;

    @ApiModelProperty("至合作伙伴编码")
    String iPCode;
    String iPName;

    @ApiModelProperty("从包")
    String olimit1;

    @ApiModelProperty("到包")
    String ilimit1;
}
