package com.elitesland.yst.production.inv.domain.entity.scene;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author Tom.su
 * @program yst-inv
 * @description 库存场景明细配置
 * @date 2022/04/20 14:29
 */
@Entity
@Table(name = "inv_scene_config_dtl")
@org.hibernate.annotations.Table(appliesTo = "inv_scene_config_dtl", comment = "库存场景配置明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "inv_scene_config_dtl", description = "库存场景配置明细")
public class InvSceneConfigDtlDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -6829086191452645974L;

    @ApiModelProperty(value = "主表ID")
    @Column(name = "mas_id",columnDefinition = "varchar(20)  comment '主表ID'")
    private Long masId;

    @ApiModelProperty(value = "操作码")
    @Column(name = "io_code",columnDefinition = "varchar(20)  comment '操作码'")
    private String ioCode;

    @ApiModelProperty(value = "操作类型")
    @Column(name = "io_type",columnDefinition = "varchar(20)  comment '操作类型'")
    private String ioType;

    @ApiModelProperty(value = "操作描述,限长200位")
    @Column(name = "opt_desc",columnDefinition = "varchar(200)  comment '操作描述'")
    private String optDesc;

    @ApiModelProperty(value = "执行序列")
    @Column(name = "opt_seq",columnDefinition = "int(6)  comment '执行序列'")
    private Integer optSeq;

    @ApiModelProperty(value = "关联单据是否必传 Y-是 N-否")
    @Column(name = "is_rel_doc_req",columnDefinition = "varchar(6)  comment '关联单据是否必传 Y-是 N-否'")
    private String isRelDocReq;

    @ApiModelProperty(value = "是否使用关联单据操作库存 Y-是 N-否")
    @Column(name = "is_use_rel_doc",columnDefinition = "varchar(6)  comment '是否使用关联单据操作库存 Y-是 N-否'")
    private String isUseRelDoc;

    @ApiModelProperty(value = "关联单据类型")
    @Column(name = "rel_doc_type",columnDefinition = "varchar(6)  comment '关联单据类型'")
    private String relDocType;

    @ApiModelProperty(value = "指定功能区编码")
    @Column(name = "deter2",columnDefinition = "varchar(40)  comment '指定功能区编码'")
    private String deter2;

    @ApiModelProperty(value = "库存操作体")
    @Column(name = "whopt_type",columnDefinition = "varchar(20)  comment '库存操作体'")
    private String whoptType;




}