package com.elitesland.yst.production.inv.domain.service;

import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.ck.InvCkRespVO;
import com.elitesland.yst.production.inv.domain.entity.ck.InvCk;
import com.elitesland.yst.production.inv.infr.dto.ck.InvCkDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.Optional;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/14
 * @Version 1.0
 * @Content:
 */
public interface InvCkDomainService {

    /**
     * 根据ID查询库存盘点信息
     *
     * @param id 库存盘点ID
     * @return 库存盘点对象
     */
    Optional<InvCkDTO> findById(Long id);

    /**
     * 库存盘点保存
     *
     * @param invCk
     * @return
     */
    Long saveInvCk(InvCk invCk);

    /**
     * 库存盘点分页查询
     *
     * @param param
     * @return
     */
    PagingVO<InvCkRespVO> invCkSearch(InvCkParamVO param);

    void updateDocStatus(Long id,String docStatus);

    void updateIsAjStatus(Long id,Integer isAjStatus);

    void updateProcInstStatusById(ProcInstStatus procInstStatus, Long id);

    void updateProcInst(ProcessInfo processInfo, Long id, String docStatus);
}
