package com.elitesland.yst.production.inv.domain.service;

import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRpcDtoParam;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhDeter2RespVO;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhAreaDO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaRpcDTO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;
import java.util.Optional;

public interface InvWhAreaDomainService {
    PagingVO<InvWhAreaRespVO> searchPaging(InvWhAreaParamVO queryParam);

    List<InvWhAreaRespVO> findByWhId(Long whId);

    List<InvWhAreaRespVO> findWhAreasByParam(InvWhAreaParamVO paramVO);

    void deleteByWhId(Long whId);

    void deleteBatch(List<Long> list);

    InvWhAreaDO saveInvWhArea(InvWhAreaDO invWhAreaDO);

    int saveInvWhAreaList(List<InvWhAreaDO> invWhAreaDO);

    List<InvWhAreaDO> saveInvWhAreas(List<InvWhAreaDO> invWhAreaDO);

    Optional<InvWhAreaDO> findOneById(Long id);

    /**
     * 根据仓库id、功能区查询
     * @param whId 仓库id
     * @param whArea 功能区
     * @return
     */
    InvWhAreaRespVO findByWhIdAndWhArea(Long whId, String whArea);

    List<InvWhAreaRpcDTO> selectWhAreaRpcDTOByParam(InvWhAreaRpcDtoParam paramVO);

    List<InvWhDeter2RespVO> findDeter2sByWhId(Long id);

    List<InvWhAreaRespVO> findByDeter2Names(List<String> deter2Names);

    List<InvWhAreaRespVO> findByDeter2KeyWord(String deter2KeyWord);

    List<InvWhAreaRespVO> findAllWhareas();

    List<InvWhAreaRespVO> findBydeter2s(List<String> deter2s);


}
