package com.elitesland.yst.production.inv.domain.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.elitesland.yst.production.inv.application.facade.vo.*;
import com.elitesland.yst.production.inv.domain.convert.InvAsmDConvert;
import com.elitesland.yst.production.inv.domain.entity.InvAsmD;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDDO;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDO;
import com.elitesland.yst.production.inv.domain.service.InvAsmDDomainService;
import com.elitesland.yst.production.inv.entity.*;
import com.elitesland.yst.production.inv.infr.dto.InvAsmAndAsmDDTO;
import com.elitesland.yst.production.inv.infr.repo.InvAsmDRepo;
import com.elitesland.yst.production.inv.infr.repo.InvAsmDRepoProc;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.AllArgsConstructor;
import lombok.val;
import org.apache.commons.collections4.MapUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.transaction.Transactional;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author lu.wang
 * @date 2020-08-12 08:27
 * Desc:
 */
@Service
@AllArgsConstructor
public class InvAsmDDomainServiceImpl implements InvAsmDDomainService {

    private final InvAsmDRepo invAsmDRepo;
    private final InvAsmDRepoProc invAsmDRepoProc;



    @Override
    @SysCodeProc
    public PagingVO<InvAsmAndAsmDDTO> search(InvAsmAllQueryParam param) {
        val invAsms = invAsmDRepoProc.selectH(param);
        param.fillOrders(invAsms);
        param.setPaging(invAsms);
        val asms = invAsms.fetch();
        return PagingVO.<InvAsmAndAsmDDTO>builder()
                .total(invAsms.fetchCount())
                .records(asms)
                .build();
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> invAsmDRepo.deleteById(id));
    }

    @Override
    @Transactional
    public void createBatch(List<InvAsmD> invAsmDList) {
        List<InvAsmDDO> invAsmDS = invAsmDList.stream().map(invAsmD -> {
            InvAsmDDO invAsmDDO = InvAsmDConvert.INSTANCE.asmdToDo(invAsmD);
            return invAsmDDO;
        }).collect(Collectors.toList());
        invAsmDRepo.saveAll(invAsmDS);
    }


    @Override
    @SysCodeProc
    public List<InvAsmDRespVO> listByCostCal(InvCalCostQueryParam param, int current, int PAGE_SIZE){
        Pageable pageable = PageRequest.of(current-1, PAGE_SIZE);
        val invAsms = invAsmDRepoProc.listByCostCal(param,pageable);
        return  invAsms.stream().map(InvAsmDConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    @SysCodeProc
    public List<InvAsmAndAsmDDTO> findAll(InvAsmAllQueryParam param) {
        val invAsms = invAsmDRepoProc.selectD(param).fetch();
        return invAsms;
    }

    @Override
    @Transactional
    public int removeInBatch(List<Long> ids) {
        ids.forEach(id -> invAsmDRepo.deleteById(id));
        return ids.size();
    }

    @Override
    public List<InvAsmDDO> findByMasId(Long masId) {
        List<InvAsmDDO> invAsmDDOS = invAsmDRepo.findByMasId(masId);
        return invAsmDDOS;
    }


}
