package com.elitesland.yst.production.inv.domain.service.impl;
import com.elitesland.yst.production.inv.domain.convert.InvTrnConvert;
import com.elitesland.yst.production.inv.domain.entity.invtrn.InvTrn;
import com.elitesland.yst.production.inv.domain.service.InvTrnDomainService;
import com.elitesland.yst.production.inv.entity.InvTrnDO;
import com.elitesland.yst.production.inv.infr.dto.InvTrnDTO;
import com.elitesland.yst.production.inv.infr.repo.InvTrnRepo;
import com.elitesland.yst.production.inv.infr.repo.InvTrnRepoProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;



/**
 * @author jeesie.jiang
 * @date 2022-03-17 11:37
 * Desc:
 */
@Slf4j
@Service
@AllArgsConstructor
public class InvTrnDomainServiceImpl implements InvTrnDomainService {
    private final InvTrnRepo invTrnRepo;
    private final InvTrnRepoProc invTrnRepoProc;


    @Override
    public Optional<InvTrnDTO> findIdOne(Long id) {
        Optional<InvTrnDTO> invTrnDTO = invTrnRepo.findById(id).map(invTrnDO -> {
            return InvTrnConvert.INSTANCE.doToDTO(invTrnDO);
        });
        return invTrnDTO ;
    }

    @Override
    @Transactional
    public Long create(InvTrn invTrn) {
        InvTrnDO invTrnDO = InvTrnConvert.INSTANCE.trnToDO(invTrn);
        val id = invTrnRepo.save(invTrnDO).getId();
        return id;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long submit(Long id) {
        Optional<InvTrnDO> invTrnVOOptional = invTrnRepo.findById(id);
        if (!invTrnVOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + id);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDocStatusByIds(List<Long> ids,String docStatus) {
        invTrnRepoProc.updateDocStatusByIds(ids,docStatus);

    }


}
