package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhDeliveryDO;
import com.elitesland.yst.production.inv.domain.service.InvWhDeliveryDomainService;
import com.elitesland.yst.production.inv.infr.repo.InvWhDeliveryRepo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.function.Consumer;

@Service("InvWhDeliveryDomainService")
@AllArgsConstructor
public class InvWhDeliveryDomainServiceImpl implements InvWhDeliveryDomainService {

    private final InvWhDeliveryRepo invWhDeliveryRepo;

    @Override
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> invWhDeliveryRepo.deleteById(id));
    }

    @Override
    public void deleteBatch(Long id) {
        invWhDeliveryRepo.deleteById(id);
    }

    @Override
    public InvWhDeliveryDO saveInvWhDelivery(InvWhDeliveryDO invWhDeliveryDO) {
        return invWhDeliveryRepo.save(invWhDeliveryDO);
    }

    @Override
    public int saveInvWhDeliveryList(List<InvWhDeliveryDO> invWhDeliveryDOList) {
        return invWhDeliveryRepo.saveAll(invWhDeliveryDOList).size();
    }

    @Override
    public List<InvWhDeliveryDO> saveInvWhDeliveries(List<InvWhDeliveryDO> invWhDeliveryDOList) {
        return invWhDeliveryRepo.saveAll(invWhDeliveryDOList);
    }

    @Override
    @Transactional
    public void updateInvWhDelivery(InvWhDeliveryDO invWhDeliveryDO){
        invWhDeliveryRepo.save(invWhDeliveryDO);
    }
}
