package com.elitesland.yst.production.inv.infr.dto;

import com.elitesland.yst.production.inv.application.facade.vo.InvAsmDRespVO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author lu.wang
 * @date 2020-08-11 16:03
 * Desc: 库内组装VO
 */
@Data
@ApiModel(value = "INV_ASM", description = "库内组装")
public class InvAsmDTO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -5919526380602228714L;
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long ouId;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long buId;

    @ApiModelProperty("单据编号")
    String docNo;

    @ApiModelProperty("组装类型 [UDC]INV:ASM_TYPE")
    String docType;

    @ApiModelProperty("组装类型 [UDC]INV:ASM_TYPE")
    String docTypeName;

    @ApiModelProperty("组装单状态 [UDC]INV:ASM_STATUS")
    String docStatus;

    @ApiModelProperty("组装单状态 [UDC]INV:ASM_STATUS")
    String docStatusName;

    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    String apprStatus;

    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    String apprStatusName;

    @ApiModelProperty("流程实例ID")
    String apprProcInstId;

    @ApiModelProperty("审批时间")
    LocalDateTime apprTime;

    @ApiModelProperty("审批人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long apprUserId;

    @ApiModelProperty("审批意见")
    String apprComment;

    @ApiModelProperty("申请人员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long applyEmpId;

    @ApiModelProperty("申请人员工")
    String applyEmpName;

    @ApiModelProperty("申请日期")
    LocalDateTime applyDate;

    @ApiModelProperty("申请描述")
    String applyDesc;

    @ApiModelProperty("交易日期 实际出入库日期")
    LocalDateTime ioDate;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long whId;

    @ApiModelProperty("仓库名称")
    String whName;

    @ApiModelProperty("仓库IDs")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> whIds;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    String deter1;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    String deter1Name;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    String deter2;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    String deter2Name;

    @ApiModelProperty("客户标识")
    String deter3;

    @ApiModelProperty("限定4")
    String deter4;

    @ApiModelProperty("限定5")
    String deter5;

    @ApiModelProperty("限定6")
    String deter6;

    @ApiModelProperty("限定7")
    String deter7;

    @ApiModelProperty("限定8")
    String deter8;

    @ApiModelProperty("税额")
    BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    BigDecimal amt;

    @ApiModelProperty("不含税金额")
    BigDecimal netAmt;

    @ApiModelProperty("记账币种")
    String homeCurr;

    @ApiModelProperty("交易币种")
    String currCode;

    @ApiModelProperty("汇率")
    Float currRate;

    @ApiModelProperty("外币不含税金额")
    BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    BigDecimal currAmt;

    @ApiModelProperty("成本金额")
    BigDecimal costAmt;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    String reasonCode;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    String reasonCodeName;

    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    String relateDocCls;

    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    String relateDocClsName;

    @ApiModelProperty("关联单据类型")
    String relateDocType;

    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long relateDocId;

    @ApiModelProperty("关联单据编号")
    String relateDocNo;

    @ApiModelProperty("关联ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long relateId;

    @ApiModelProperty("关联编号")
    String relateNo;

    @ApiModelProperty("关联2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long relate2Id;

    @ApiModelProperty("关联2编号")
    String relate2No;

    @ApiModelProperty("是否走接口")
    Integer intfFlag;

    @ApiModelProperty("明细列表")
    List<InvAsmDRespVO> invAsmDRespVOList;

    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    public String getProcInstStatusName() {
        return procInstStatus != null ? procInstStatus.getDesc() : null;
    }

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("单据类别")
    private String docCls;

}
