package com.elitesland.yst.production.inv.infr.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Tom.su
 * @program yst-inv
 * @description
 * @date 2022/04/26 10:24
 */
@Data
public class InvSceneConfigDTO implements Serializable {

    private static final long serialVersionUID = 3078682587596144342L;

    @ApiModelProperty("记录唯一ID,更新时必传")
    private Long id;

    @ApiModelProperty("库存场景码")
    private String sceneCode;

    @ApiModelProperty("库存场景描述，限定长度60中文字符之内")
    private String sceneDesc;

    @ApiModelProperty("触发单据类型")
    @SysCode(sys = "COM",mod = "DOC_CLS")
    private String optDocType;

    @ApiModelProperty("触发单据类型名称")
    private String optDocTypeName;


    @ApiModelProperty("触发单据操作描述")
    private String optDocDesc;

    @ApiModelProperty("启用状态  Y-是 N-否")
    private String isEnable;

    private List<InvSceneConfigDtlDTO> invSceneConfigDtlList;


}