package com.elitesland.yst.production.inv.infr.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Tom.su
 * @program yst-inv
 * @description
 * @date 2022/04/26 10:24
 */
@Data
public class InvSceneConfigDtlDTO  implements Serializable {
    private static final long serialVersionUID = -6636051829799954013L;
    @ApiModelProperty("记录唯一ID，更新时必传")
    private Long id;

    @ApiModelProperty(value = "主表ID")
    private Long masId;

    @ApiModelProperty(value = "操作码")
    private String ioCode;

    @ApiModelProperty(value = "操作类型")
    private String ioType;

    @ApiModelProperty(value = "操作描述,限长200位")
    private String optDesc;

    @ApiModelProperty(value = "执行序列")
    private Integer optSeq;

    @ApiModelProperty(value = "关联单据是否必传 Y-是 N-否")
    private String isRelDocReq;

    @ApiModelProperty(value = "是否使用关联单据操作库存 Y-是 N-否")
    private String isUseRelDoc;

    @ApiModelProperty(value = "关联单据类型")
    @SysCode(sys = "COM",mod = "DOC_CLS")
    private String relDocType;

    @ApiModelProperty(value = "指定功能区编码")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;

    @ApiModelProperty(value = "库存操作体")
    private String whoptType;


    @Override
    public String toString() {
        return "InvSceneConfigDtlDTO{" +
                "id=" + id +
                ", masId=" + masId +
                ", ioCode='" + ioCode + '\'' +
                ", ioType='" + ioType + '\'' +
                ", optDesc='" + optDesc + '\'' +
                ", optSeq=" + optSeq +
                ", isRelDocReq='" + isRelDocReq + '\'' +
                ", isUseRelDoc='" + isUseRelDoc + '\'' +
                ", relDocType='" + relDocType + '\'' +
                ", deter2='" + deter2 + '\'' +
                ", whoptType='" + whoptType + '\'' +
                '}';
    }
}