package com.elitesland.yst.production.inv.infr.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author Tom.su
 * @program yst-inv
 * @description
 * @date 2022/04/24 10:46
 */
@Data
@ApiModel(value = "库存操作公共入参", description = "库存操作公共入参")
public class InvStkCommonOperateBodyDTO implements Serializable {

    private static final long serialVersionUID = -4841294700852583852L;
    @ApiModelProperty("操作数量")
    private BigDecimal qty;

    @ApiModelProperty("单据号")
    @NotBlank(message = "单据号不能为空")
    private String docNo;

    @ApiModelProperty("行号")
    private Double lineNo;

    @ApiModelProperty("日期")
    private LocalDateTime opDate;

    @ApiModelProperty("操作人")
    @NotNull
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("来源单据类别")
    @NotBlank(message = "来源单据类别不能为空")
    private String srcDocCls;

    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotBlank(message = "来源单据ID不能为空")
    private Long srcDocId;

    @ApiModelProperty("来源单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotBlank(message = "来源单据明细ID不能为空")
    private Long srcDocDid;

    @ApiModelProperty("来源单据关联的订单类别")
    private String srcDocCls2;

    @ApiModelProperty("来源单据ID2")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId2;

    @ApiModelProperty("来源单据编号2")
    private String srcDocNo2;

    @ApiModelProperty("来源订单明细ID2")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocDid2;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品ID")
    @NotNull
    private Long itemId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("异构ID")
    private Long variId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("仓库ID")
    @NotNull
    private Long whId;

    @ApiModelProperty("温层[UDC]INV:TEMP_TYPE")
    private String deter1;

    @ApiModelProperty("功能库区[UDC]INV:FUNC_TYPE")
    @NotEmpty
    private String deter2;

    @ApiModelProperty("指定的功能区")
    private String optDeter2;

    @ApiModelProperty("客户号")
    private String deter3;

    @ApiModelProperty("库存合作伙伴类型")
    private String pType;
    @ApiModelProperty("库存合作伙伴编码")
    private String pCode;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("单位")
    @NotBlank(message = "商品单位不能为空")
    private String uom;

    @ApiModelProperty("limit1")
    private String limit1;

    @ApiModelProperty("limit2")
    private String limit2;

    @ApiModelProperty("limit3")
    private String limit3;

    @ApiModelProperty("序列号")
    private String snNo;


    @ApiModelProperty("销售配货单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocDDid;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @Override
    public String toString() {
        return "InvStkCommonOperateBodyDTO{" +
                "qty=" + qty +
                ", docNo='" + docNo + '\'' +
                ", lineNo=" + lineNo +
                ", opDate=" + opDate +
                ", createUserId=" + createUserId +
                ", srcDocCls='" + srcDocCls + '\'' +
                ", srcDocId=" + srcDocId +
                ", srcDocDid=" + srcDocDid +
                ", srcDocCls2='" + srcDocCls2 + '\'' +
                ", srcDocId2=" + srcDocId2 +
                ", srcDocNo2='" + srcDocNo2 + '\'' +
                ", srcDocDid2=" + srcDocDid2 +
                ", itemId=" + itemId +
                ", variId=" + variId +
                ", whId=" + whId +
                ", deter1='" + deter1 + '\'' +
                ", deter2='" + deter2 + '\'' +
                ", deter3='" + deter3 + '\'' +
                ", pType='" + pType + '\'' +
                ", pCode='" + pCode + '\'' +
                ", lotNo='" + lotNo + '\'' +
                ", uom='" + uom + '\'' +
                ", limit1='" + limit1 + '\'' +
                ", limit2='" + limit2 + '\'' +
                ", limit3='" + limit3 + '\'' +
                ", snNo='" + snNo + '\'' +
                ", srcDocDDid='" + srcDocDDid +'\'' +
                ", ouId=" + ouId +
                '}';
    }
}
