package com.elitesland.yst.production.inv.infr.dto.ck;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.boot.model.entity.BaseModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/14
 * @Version 1.0
 * @Content:
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class InvCkDDTO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 7118625935234720393L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主表id")
    private Long masId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("仓库id")
    private Long whId;

    @ApiModelProperty("功能区")
    private String deter2;

    @ApiModelProperty("功能区名称")
    private String deter2Name;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("品牌编码")
    private String brand;

    @ApiModelProperty("品牌名称")
    private String brandName;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("商品规格")
    private String spec;

    @ApiModelProperty("账面数")
    private BigDecimal accQty;

    @ApiModelProperty("实盘数")
    private BigDecimal factQty;

    @ApiModelProperty("差异数")
    private BigDecimal diffQty;

    @ApiModelProperty("库存单位")
    private String uom;

    @ApiModelProperty("库存单位名称")
    private String uomName;

    @ApiModelProperty("是否默认启用批次")
    Boolean lotFlag;

    @ApiModelProperty("库存合作伙伴编码")
    private String pCode;

    @ApiModelProperty("库存合作类型")
    @SysCode(sys = "yst-inv",mod = "PARTNER_TYPE")
    private String pType;
    private String pTypeName;

    @ApiModelProperty("库存合作伙伴名")
    private String pName;
}
