package com.elitesland.yst.production.inv.infr.repo;



import com.alibaba.excel.util.CollectionUtils;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjAndInvAjDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjDQueryAllParamVO;
import com.elitesland.yst.production.inv.domain.entity.QInvAjDDO;
import com.elitesland.yst.production.inv.domain.entity.QInvAjDO;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.core.security.dataauth.metadata.DataAuthBusinessJpaUtil;
import com.elitescloud.cloudt.core.security.dataauth.metadata.DataAuthResult;
import com.elitescloud.cloudt.core.security.dataauth.metadata.MateDatePredicateVo;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhAreaDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;


@Slf4j
@Component
@AllArgsConstructor
public class InvAjDRepoProc implements JpaQueryProcInterface {
    private final JPAQueryFactory jpaQueryFactory;


    /**
     * 前端分页专用
     */
    public Predicate searchWhere(InvAjDQueryAllParamVO param) {
        val invajd = QInvAjDDO.invAjDDO;
        val invaj = QInvAjDO.invAjDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        predicate = param.getMasId() == null ? predicate :
                ExpressionUtils.and(predicate, invajd.masId.eq(param.getMasId()));
        // 是否已销毁
        predicate = StringUtils.isEmpty(param.getDestroyFlag()) ? predicate :
                ExpressionUtils.and(predicate, invajd.destroyFlag.isNull().or(invajd.destroyFlag.isFalse()));


        predicate = (StringUtils.isEmpty(param.getCreateTimeStart()) || StringUtils.isEmpty(param.getCreateTimeEnd()))  ? predicate :
                ExpressionUtils.and(predicate, invaj.createTime.between(param.getCreateTimeStart(), param.getCreateTimeEnd()));

        predicate = (StringUtils.isEmpty(param.getApplyDateStart()) || StringUtils.isEmpty(param.getApplyDateEnd()))  ? predicate :
                ExpressionUtils.and(predicate, invaj.applyDate.between(param.getApplyDateStart(),param.getApplyDateEnd()));

        //仓库id
        predicate = param.getWhIds() == null || param.getWhIds().size() == 0 ? predicate :
                ExpressionUtils.and(predicate, invaj.whId.in(param.getWhIds()));
        //温层
        predicate = StringUtils.isEmpty(param.getDeter1()) ? predicate :
                ExpressionUtils.and(predicate, invajd.deter1.eq(param.getDeter1()));

        //是否外部单据同步
        predicate = StringUtils.isEmpty(param.getSourceFlag()) ? predicate :
                ExpressionUtils.and(predicate, invaj.sourceFlag.eq(param.getSourceFlag()));

        //功能区
        predicate = param.getDeter2() == null || param.getDeter2().size() == 0 ? predicate :
                ExpressionUtils.and(predicate, invajd.deter2.in(param.getDeter2()));
        //客户标识
        predicate = StringUtils.isEmpty(param.getDeter3()) ? predicate :
                ExpressionUtils.and(predicate, invaj.deter3.like("%" + param.getDeter3() + "%"));
        //商品
        predicate = param.getItemIds() == null || param.getItemIds().size() == 0 ? predicate :
                ExpressionUtils.and(predicate, invajd.itemId.in(param.getItemIds()));
        //批次号
        predicate = StringUtils.isEmpty(param.getLotNo()) ? predicate :
                ExpressionUtils.and(predicate, invajd.lotNo.like("%" + param.getLotNo() + "%"));
        //申请日期
        predicate = param.getApplyDates() == null || param.getApplyDates().size() == 0 ? predicate :
                ExpressionUtils.and(predicate, invaj.applyDate.between(param.getApplyDates().get(0), param.getApplyDates().get(1)));
        //调整类型
        predicate = StringUtils.isEmpty(param.getDocType()) ? predicate :
                ExpressionUtils.and(predicate, invaj.docType.eq(param.getDocType()));
        //单据编号
        predicate = StringUtils.isEmpty(param.getDocNo()) ? predicate :
                ExpressionUtils.and(predicate, invaj.docNo.like("%" + param.getDocNo() + "%"));
        //关联单据号
        predicate = StringUtils.isEmpty(param.getRelateNo()) ? predicate :
                ExpressionUtils.and(predicate, invaj.relateNo.like("%" + param.getRelateNo() + "%"));
        //关联单据号（RMA）
        predicate = StringUtils.isEmpty(param.getRelateDocNo()) ? predicate :
                ExpressionUtils.and(predicate, invajd.relateDocNo.like("%" + param.getRelateDocNo() + "%"));
        //库存合作伙伴编码
        predicate = StringUtils.isEmpty(param.getPCode()) ? predicate :
                ExpressionUtils.and(predicate, invajd.pCode.like("%" + param.getPCode() + "%"));
        //审批状态
        predicate = StringUtils.isEmpty(param.getApprStatus()) ? predicate :
                ExpressionUtils.and(predicate, invaj.apprStatus.like("%" + param.getApprStatus() + "%"));
        //流程审批状态
        predicate = StringUtils.isEmpty(param.getProcInstStatus()) ? predicate :
                ExpressionUtils.and(predicate, invaj.procInstStatus.eq(param.getProcInstStatus()));
        //创建日期
        predicate = param.getCreateTime() == null || param.getCreateTime().size() == 0 ? predicate :
                ExpressionUtils.and(predicate, invaj.createTime.between(param.getCreateTime().get(0), param.getCreateTime().get(1)));
        //交易日期
        predicate = param.getIoDates() == null || param.getIoDates().size() == 0 ? predicate :
                ExpressionUtils.and(predicate, invaj.ioDate.between(param.getIoDates().get(0), param.getIoDates().get(1)));
        //调整单状态 - 按照产品要求放开限制
        predicate = StringUtils.isEmpty(param.getDocStatus()) ? predicate : ExpressionUtils.and(predicate, invaj.docStatus.eq(param.getDocStatus()));

        // 公司
        predicate = CollectionUtils.isEmpty(param.getOuIds()) ? predicate : ExpressionUtils.and(predicate,invaj.ouId.in(param.getOuIds()));
        // 原因码
        predicate = StringUtils.isEmpty(param.getReasonCode()) ? predicate : ExpressionUtils.and(predicate,invajd.reasonCode.eq(param.getReasonCode()));
        // 申请人
        predicate = CollectionUtils.isEmpty(param.getApplyEmpIds()) ? predicate : ExpressionUtils.and(predicate,invaj.applyEmpId.in(param.getApplyEmpIds()));
        if(StringUtils.hasLength(param.getDeter2KeyWord())){
            predicate = ExpressionUtils.and(predicate, ExpressionUtils.or(
                    invWhAreaDO.deter2.like("%" + param.getDeter2KeyWord() + "%"),
                    invWhAreaDO.deter2Name.like("%" + param.getDeter2KeyWord() + "%")
            ));
        }

        /**
         * lu.wang 2020-12-14 18:33:07
         * 外部单据号取值
         */
        predicate = StringUtils.isEmpty(param.getOuterNo()) ? predicate :
                ExpressionUtils.and(predicate, invajd.outerNo.like("%" + param.getOuterNo() + "%"));
        //调整类型
        predicate = StringUtils.isEmpty(param.getDocCls()) ? predicate :
                ExpressionUtils.and(predicate, invaj.docCls.eq(param.getDocCls()));
        /**数据权限*/
        try {
            Predicate   predicateAuth=   DataAuthJpaUtil.dataAuthJpaPredicate(invaj.getMetadata());
            predicate=  ExpressionUtils.and(predicate,predicateAuth);
        } catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL,"数据权限异常");
        }
        return predicate;
    }

    /**
     * 前端分页专用
     */
    public JPAQuery<InvAjAndInvAjDRespVO> ajSelect() {
        val invajd = QInvAjDDO.invAjDDO;
        val invaj = QInvAjDO.invAjDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        JPAQuery<InvAjAndInvAjDRespVO> jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        InvAjAndInvAjDRespVO.class,
                        invaj.id,
                        invaj.docNo,
                        invaj.applyEmpId,
                        invaj.relate2No,
                        invaj.relateNo,
                        invaj.ioDate,
                        invaj.sourceFlag,
                        invaj.apprTime,
                        invaj.apprStatus,
                        invaj.apprUserId,
                        invaj.apprProcInstId,
                        invaj.procInstId,
                        invaj.procInstStatus,
                        invaj.submitTime,
                        invaj.approvedTime,
                        invaj.remark,
                        invaj.createUserId,
                        invaj.creator,
                        invaj.createTime,
                        invaj.modifyUserId,
                        invaj.updater,
                        invaj.modifyTime,
                        invaj.deleteFlag,
                        invaj.ouId,
                        invaj.whId,
                        invWhDO.whCode,
                        invWhDO.whName,
                        invaj.docType,
                        invaj.docStatus,
                        invaj.applyDate,
                        invaj.secBuId,
                        invaj.secOuId,
                        invaj.secUserId,
                        invaj.region,
                        invaj.docCls,
                        invajd.id.as("did"),
                        invajd.masId,
                        invaj.reasonCode,
                        invajd.deter1,
                        invajd.deter2,
                        invWhAreaDO.deter2Name,
                        invajd.deter3,
                        invajd.lotNo,
                        invajd.menuLotNo,
                        invajd.itemId,
                        invajd.deter4,
                        invajd.qty,
                        invajd.uom,
                        invajd.relateDocNo,
                        invajd.manuDate,
                        invajd.expireDate,
                        invajd.destroyDate,
                        invajd.destroyFlag,
                        invajd.destroyEmpId,
                        invajd.carrier,
                        invajd.costPrice,
                        invajd.costAmt,
                        invajd.outerNo,
                        invajd.outerLineno,
                        invajd.outerOu,
                        invajd.outerType,
                        invajd.pCode.as("PCode"),
                        invajd.pType.as("PType"),
                        invajd.ajAmt,
                        invajd.limit1,
                        invajd.limit2,
                        invajd.limit3
                )
        )
                .from(invaj)
                .leftJoin(invajd).on(invajd.masId.eq(invaj.id))
                .leftJoin(invWhDO).on(invaj.whId.eq(invWhDO.id))
                .leftJoin(invWhAreaDO).on(invajd.deter2.eq(invWhAreaDO.deter2));
        //业务数据权限
        DataAuthBusinessJpaUtil dataAuthBusinessJpaUtil = new DataAuthBusinessJpaUtil();

        DataAuthResult<MateDatePredicateVo> dateAuthResult = dataAuthBusinessJpaUtil.dataAuthBusinessJpaUtil(
                jpaQuery, QInvAjDO.invAjDO,"INV"
        );
        if(dateAuthResult.isSuccess()){
            MateDatePredicateVo resultPredicate = dateAuthResult.getData();
            if(resultPredicate != null ){
                jpaQuery.where(resultPredicate.getJpaPredicate());
            }else {
                log.error("业务数据权限resultPredicate==null");
            }
        }else{
            log.error("业务数据权限失败:" + dateAuthResult.getErrorMsg()+dateAuthResult.getMsg());
        }
        jpaQuery.groupBy(invaj.id);
        return jpaQuery;
    }





}
