package com.elitesland.yst.production.inv.infr.repo.despatch;

import cn.hutool.core.lang.Tuple;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigRespVO;
import com.elitesland.yst.production.inv.domain.entity.despatch.InvDespatchConfigDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;

import java.util.List;
import java.util.Map;

/**
 * @author jeesie
 */
public interface InvDespatchConfigRepo extends JpaRepository<InvDespatchConfigDO, Long>, QuerydslPredicateExecutor<InvDespatchConfigDO> {

    @Query(value = "select count(*) as deter2Count,des.des_code as desCode from inv_despatch_config des \n" +
            "inner join inv_wh wh \n" +
            "on des.des_code = wh.des_code\n" +
            "inner join inv_wh_area area on wh.id = area.wh_id\n" +
            "where des.des_code in(?1)\n" +
            "GROUP BY des.des_code", nativeQuery = true)
    List<Map<String,Object>> getdeter2Count(List<String> descCodes);
    
}
