package com.elitesland.yst.production.inv.job.task;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitesland.yst.production.inv.job.config.JobConstant;
import com.elitesland.yst.production.inv.job.service.InvStkSsJobService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class InvStkSsHandler {

    @Autowired
    private InvStkSsJobService invStkSsJobService;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;


    @XxlJob(JobConstant.INV_Stk_SS_HANDLER)
    public ReturnT<String> invStkSsSync(String param){
        try {
            invStkSsJobService.storageInfoSync(param,tenantDataIsolateProvider);
        } catch (Exception e) {
            log.error("库存快照定时任务执行失败：",e);
            throw new BusinessException("库存快照定时任务执行失败:"+e.getMessage());
        }
        return ReturnT.SUCCESS;
    }
}
