package com.elitesland.yst.production.inv.utils;

import com.elitesland.yst.production.inv.enums.ProcDefKey;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Tom.su
 * @program yst-pur
 * @description
 * @date 2022/04/21 10:12
 */
public class InvStringUtil {

    public static String workFlowCallBackPath(String procKey){
        return "workflow/" + ProcDefKey.INV_TRN.name() + "/callBack";
    }
    public static int lengthOfUTF8(String value) {
        int valueLength = 0;
        if(value==null)
        {
            return valueLength;
        }
        String chinese = "[\u0391-\uFFE5]";
        /* 获取字段值的长度，如果含中文字符，则每个中文字符长度为3，否则为1 */
        for (int i = 0; i < value.length(); i++) {
            /* 获取一个字符 */
            String temp = value.substring(i, i + 1);
            /* 判断是否为中文字符 */
            if (temp.matches(chinese)) {
                /* 中文字符长度为3 */
                valueLength += 3;
            } else {
                /* 其他字符长度为1 */
                valueLength += 1;
            }
        }
        return valueLength;
    }

    public static void main(String[] args) {
        System.out.println(lengthOfUTF8("埃林哲"));
    }


    /**
     * 字符串转换为编码集合,以逗号分隔的字符串形式
     *
     * @param codeString 以逗号分隔的字符串
     * @return 编码集合
     */
    public static List<String> transitionStrToCodes(String codeString) {
        if (StringUtils.isEmpty(codeString)) {
            return Collections.emptyList();
        }
        List<String> codeList = Arrays.asList(codeString.split(","));

        return codeList;
    }

    /**
     * 编码集合转换为字符串,以逗号分隔的字符串形式
     *
     * @param codeList 编码集合
     * @return 以逗号分隔的字符串
     */
    public static String transitionCodesToStr(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return null;
        }
        String codeString = codeList.stream().distinct().collect(Collectors.joining(","));

        return codeString;
    }

}
