/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjDSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvRoCommon30InSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvStkCommon28InSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvStkCommon37InSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCommon21InVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCommonSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotSaveVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvAjService;
import com.elitesland.yst.production.inv.application.service.InvLotCommonService;
import com.elitesland.yst.production.inv.application.service.InvLotService;
import com.elitesland.yst.production.inv.application.service.InvStkCommonService;
import com.elitesland.yst.production.inv.application.service.InvStkService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaService;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.domain.convert.InvAjConvert;
import com.elitesland.yst.production.inv.domain.convert.InvAjDConvert;
import com.elitesland.yst.production.inv.domain.entity.InvAj;
import com.elitesland.yst.production.inv.domain.entity.InvAjD;
import com.elitesland.yst.production.inv.domain.entity.QInvAjDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhDO;
import com.elitesland.yst.production.inv.domain.service.InvAjDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvAjDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.enums.InvStkSceneCodeEnum;
import com.elitesland.yst.production.inv.enums.ProcDefKey;
import com.elitesland.yst.production.inv.infr.dto.InvAjDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.spi.InvAjSpi;
import com.elitesland.yst.production.inv.utils.BeanCopyUtil;
import com.elitesland.yst.production.inv.utils.InvStk28Enum;
import com.elitesland.yst.production.inv.utils.NumSendObjectEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.vo.InvAjVO;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgBuRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.google.common.util.concurrent.AtomicDouble;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class InvAjServiceImpl
implements InvAjService {
    private static final Logger log = LoggerFactory.getLogger(InvAjServiceImpl.class);
    private final JPAQueryFactory jpaQueryFactory;
    private final InvAjDomainService invAjDomainService;
    private final InvAjDDomainService invAjDDomainService;
    private final SystemService systemService;
    private final TransactionTemplate transactionTemplate;
    private final WorkflowService workflowService;
    private final InvWhAreaService invWhAreaService;
    private final ItmOutService itmOutService;
    private final InvStkCommonService invStkCommonService;
    private final OrgOutService orgOutService;
    private final InvWhDomainService invWhDomainService;
    private final InvStkService invStkService;
    private final InvLotCommonService invLotCommonService;
    private final InvLotService invLotService;
    private final InvStkOptBizService invStkOptBizService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOneInvAj(InvAjSaveVO invAjSaveVO) {
        invAjSaveVO.setCreateTime(LocalDateTime.now());
        this.checkInvAjQty(invAjSaveVO);
        Long masId = this.saveInvAj(invAjSaveVO);
        List<InvAjDSaveVO> invAjDSaveVOList = invAjSaveVO.getInvAjDSaveVOList();
        if (!CollectionUtils.isEmpty(invAjDSaveVOList)) {
            this.whVerify(invAjSaveVO.getInvAjDSaveVOList());
        }
        this.saveInvAjDVOS(invAjSaveVO, masId);
        return masId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelBatch(List<Long> ids) {
        ids.forEach(id -> {
            InvAjDTO invAjDTO = this.invAjDomainService.findById((Long)id);
            if (Objects.isNull(invAjDTO)) {
                throw new BusinessException(ApiCode.FAIL, "\u6b64\u5e93\u5b58\u8c03\u6574\u4f46\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            if (!UdcEnum.INV_AJ_STATUS_DR.getValueCode().equals(invAjDTO.getDocStatus()) && !UdcEnum.INV_AJ_STATUS_RJ.getValueCode().equals(invAjDTO.getDocStatus())) {
                throw new BusinessException(ApiCode.FAIL, "\u53ea\u6709\u8349\u7a3f/\u5df2\u62d2\u7edd\u72b6\u6001\u7684\u8c03\u6574\u5355\u80fd\u591f\u53d6\u6d88\uff0c\u8bf7\u68c0\u67e5");
            }
            invAjDTO.setDocStatus(UdcEnum.INV_AJ_STATUS_CL.getValueCode());
            InvAj invAj = InvAjConvert.INSTANCE.invAjDTOToInvAj(invAjDTO);
            this.invAjDomainService.createInvAj(invAj);
        });
    }

    @Override
    @SysCodeProc
    public Optional<InvAjDTO> findInvAj(Long masId) {
        if (masId == null) {
            return Optional.empty();
        }
        InvAjDTO invAjDTO = this.invAjDomainService.findById(masId);
        if (Objects.nonNull(invAjDTO)) {
            this.fillUpNameList(List.of(invAjDTO));
            List<InvAjDRespVO> invAjDRespVOS = this.invAjDDomainService.findByMasId(masId);
            ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
            List itemIds = invAjDRespVOS.stream().filter(f -> f.getItemId() != null).map(InvAjDRespVO::getItemId).distinct().collect(Collectors.toList());
            itmItemPartParam.setItemIds(itemIds);
            List<String> deter2s = invAjDRespVOS.stream().map(InvAjDRespVO::getDeter2).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            InvWhAreaParamVO invWhAreaParamVO = new InvWhAreaParamVO();
            invWhAreaParamVO.setDeter2s(deter2s);
            invWhAreaParamVO.setWhId(invAjDTO.getWhId());
            List<InvWhAreaRespVO> whAreaRespVOS = this.invWhAreaService.findWhAreasByParam(invWhAreaParamVO);
            List<ItmItemRpcDTO> itmItemPartDTOS = this.itmOutService.findItemRpcDtoByParam(itmItemPartParam);
            Map<String, String> pTypeMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_PARTNER_TYPE_CUST.getModel(), UdcEnum.INV_PARTNER_TYPE_CUST.getCode());
            List<InvAjDRespVO> invAjDRespVOList = invAjDRespVOS.stream().map(e -> {
                whAreaRespVOS.stream().filter(a -> a.getDeter2().equals(e.getDeter2())).findAny().ifPresent(m -> e.setDeter2Name(m.getDeter2Name()));
                InvAjDRespVO invAjDRespVO = new InvAjDRespVO();
                BeanUtils.copyProperties((Object)e, (Object)invAjDRespVO);
                invAjDRespVO.setReasonCodeName(this.getUdcDesc(UdcEnum.INV_REASON_CODE_SKAJ.getModel(), UdcEnum.INV_REASON_CODE_SKAJ.getCode(), e.getReasonCode()));
                invAjDRespVO.setUomName(this.getUdcDesc(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode(), e.getUom()));
                if (!CollectionUtils.isEmpty((Collection)itmItemPartDTOS)) {
                    itmItemPartDTOS.stream().filter(f -> f.getId().equals(e.getItemId())).findFirst().ifPresent(i -> {
                        invAjDRespVO.setItemCode(i.getItemCode());
                        invAjDRespVO.setItemName(i.getItemName());
                        invAjDRespVO.setLotFlag(i.getLotFlag());
                    });
                }
                if (!CollectionUtils.isEmpty((Map)pTypeMap) && pTypeMap.containsKey(invAjDRespVO.getPType())) {
                    invAjDRespVO.setPTypeName((String)pTypeMap.get(invAjDRespVO.getPType()));
                }
                if (e.getPType() != null && e.getPCode() != null) {
                    InvParentParamVO paramVO = new InvParentParamVO();
                    paramVO.setCode(e.getPCode());
                    paramVO.setType(e.getPType());
                    List<OrgRespVO> vos = this.orgOutService.findcodeAndName(paramVO);
                    if (!CollectionUtils.isEmpty(vos)) {
                        invAjDRespVO.setPName(vos.get(0).getName());
                    }
                }
                invAjDRespVO.setAvalQty(this.getAvalQty(invAjDRespVO));
                if (invAjDRespVO.getLotNo() != null) {
                    invAjDRespVO.setExpireDays(this.getExpireDays(invAjDRespVO));
                }
                return invAjDRespVO;
            }).collect(Collectors.toList());
            invAjDTO.setInvAjDVOList(invAjDRespVOList);
            return Optional.of(invAjDTO);
        }
        return Optional.empty();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approveBatch(List<Long> ids) {
        ids.forEach(id -> {
            InvAjDTO invAjDTO = this.invAjDomainService.findById((Long)id);
            if (Objects.isNull(invAjDTO)) {
                throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            if (invAjDTO.getProcInstId() != null && UdcEnum.PUR_PO_STATUS_APPING.getValueCode().equals(invAjDTO.getProcInstStatus())) {
                throw new BusinessException(ApiCode.FAIL, "\u8be5\u8c03\u6574\u5355\u5df2\u5f00\u542f\u5de5\u4f5c\u6d41\uff0c\u9700\u8fdb\u5165\u5de5\u4f5c\u6d41\u5ba1\u6838\uff01");
            }
            if (!UdcEnum.INV_AJ_STATUS_APPING.getValueCode().equals(invAjDTO.getDocStatus())) {
                throw new BusinessException(ApiCode.FAIL, "\u8bf7\u9009\u62e9\u8c03\u6574\u5355\u72b6\u6001\u4e3a\u5ba1\u6838\u4e2d");
            }
            if (UdcEnum.INV_AJ_TYPE_LOT.getValueCode().equals(invAjDTO.getDocType())) {
                List<InvAjDRespVO> invAjDVOS = this.invAjDDomainService.findByMasId(invAjDTO.getId());
                ArrayList invAjDRespVOS = invAjDVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<InvAjDRespVO>(Comparator.comparing(o -> o.getItemId() + "_" + o.getLotNo() + "_" + o.getVariId()))), ArrayList::new));
                ArrayList<InvLotSaveVO> invLotVOList = new ArrayList<InvLotSaveVO>();
                invAjDRespVOS.stream().forEach(i -> {
                    if (i.getLotNo() == null) {
                        throw new BusinessException(ApiCode.FAIL, "\u6570\u636e\u5f02\u5e38\u8bf7\u68c0\u67e5\uff01\u6279\u6b21\u8c03\u6574\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    ArrayList<String> param = new ArrayList<String>();
                    param.add(i.getItemId() + "_" + i.getLotNo());
                    List<InvLotRespVO> ret = this.invLotService.findByAndItemIdAndLotNo(param);
                    if (ret.isEmpty()) {
                        if (i.getToLotNo() != null) {
                            InvLotSaveVO tmp = new InvLotSaveVO();
                            tmp.setItemId(i.getItemId());
                            if (i.getManuDate() == null || i.getExpireDate() == null) {
                                throw new BusinessException(ApiCode.FAIL, "\u6279\u6b21\u5546\u54c1\u751f\u4ea7\u65e5\u671f\u548c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                            }
                            tmp.setManuDate(i.getManuDate());
                            tmp.setExpireDate(i.getExpireDate());
                            tmp.setLotNo(i.getToLotNo());
                            tmp.setSrcDocNo(invAjDTO.getDocNo());
                            tmp.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKAJ.getValueCode());
                            tmp.setOuId(invAjDTO.getOuId());
                            invLotVOList.add(tmp);
                        }
                    } else {
                        ArrayList<InvLotCommonSaveVO> invLotCommonSaveVOS = new ArrayList<InvLotCommonSaveVO>();
                        ret.stream().forEach(v -> {
                            v.setMenuLotNo(i.getMenuLotNo());
                            InvLotCommonSaveVO lotVO = (InvLotCommonSaveVO)BeanUtil.copyProperties((Object)v, InvLotCommonSaveVO.class, (String[])new String[0]);
                            invLotCommonSaveVOS.add(lotVO);
                        });
                        this.invLotCommonService.updateInvLotInfo(invLotCommonSaveVOS);
                    }
                });
                this.invLotCommonService.createInvLotInfo(invLotVOList);
            }
            invAjDTO.setId((Long)id);
            invAjDTO.setDocStatus(UdcEnum.INV_AJ_STATUS_APPED.getValueCode());
            this.update(invAjDTO);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void refuseBatch(List<Long> ids) {
        ids.forEach(id -> {
            InvAjDTO invAjDTO = this.findIdOne((Long)id);
            if (Objects.isNull(invAjDTO)) {
                throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01 id" + id);
            }
            if (!UdcEnum.INV_AJ_STATUS_APPING.getValueCode().equals(invAjDTO.getDocStatus())) {
                throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u72b6\u6001\u5f02\u5e38\u65e0\u6cd5\u5ba1\u6279\uff0c\u8bf7\u68c0\u67e5");
            }
            List<InvAjDRespVO> invAjDVOS = this.invAjDDomainService.findByMasId((Long)id);
            List<InvStkCommon37InSaveVO> invStkCommon37InSaveVOS = this.convertCommon37InVO(invAjDVOS, invAjDTO, InvStk28Enum.T_TYPE_26);
            if (!CollectionUtils.isEmpty(invStkCommon37InSaveVOS)) {
                this.invStkCommonService.invStkCommon37(invStkCommon37InSaveVOS);
            }
            invAjDTO.setId((Long)id);
            invAjDTO.setDocStatus(UdcEnum.INV_AJ_STATUS_RJ.getValueCode());
            this.update(invAjDTO);
        });
    }

    @Override
    public void confirmInvAj(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids = ids.stream().distinct().collect(Collectors.toList()))) {
            throw new BusinessException(ApiCode.FAIL, "\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5");
        }
        for (Long id : ids) {
            InvAjDTO invAjDTO = this.findIdOne(id);
            if (Objects.isNull(invAjDTO)) {
                throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458");
            }
            invAjDTO.setIoDate(LocalDateTime.now());
            if (!UdcEnum.INV_AJ_STATUS_APPED.getValueCode().equals(invAjDTO.getDocStatus())) {
                throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u72b6\u6001\u5f02\u5e38\uff0c\u53ea\u6709\u5ba1\u6279\u5b8c\u6210\u5355\u636e\u624d\u53ef\u786e\u8ba4");
            }
            List<InvAjDRespVO> invAjDRespVOS = this.invAjDDomainService.findByMasId(id);
            if (UdcEnum.INV_AJ_TYPE_DES.getValueCode().equals(invAjDTO.getDocType())) {
                stkCommonOperateDTO = this.getInvStkCommonOperateDTO(invAjDRespVOS, invAjDTO, InvStkSceneCodeEnum.INV_AJ_AJ004.getType());
                this.invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);
            } else if (UdcEnum.INV_AJ_TYPE_STKIN.getValueCode().equals(invAjDTO.getDocType())) {
                List invAjDRespVOS1 = invAjDRespVOS.stream().filter(i -> !StringUtils.isEmpty((Object)i.getToLotNo())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(invAjDRespVOS1)) {
                    this.createLot(invAjDTO, invAjDRespVOS);
                }
                InvStkCommonOperateDTO stkCommonOperateDTO = this.getInvStkCommonOperateDTO(invAjDRespVOS, invAjDTO, InvStkSceneCodeEnum.INV_AJ_AJ001.getType());
                this.invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);
            } else if (UdcEnum.INV_AJ_TYPE_STKOUT.getValueCode().equals(invAjDTO.getDocType())) {
                stkCommonOperateDTO = this.getInvStkCommonOperateDTO(invAjDRespVOS, invAjDTO, InvStkSceneCodeEnum.INV_AJ_AJ004.getType());
                this.invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);
            } else if (UdcEnum.INV_AJ_TYPE_LOT.getValueCode().equals(invAjDTO.getDocType())) {
                this.createLot(invAjDTO, invAjDRespVOS);
                stkCommonOperateDTO = this.getInvStkCommonOperateDTO(invAjDRespVOS, invAjDTO, InvStkSceneCodeEnum.INV_AJ_AJ004.getType());
                this.invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);
                InvStkCommonOperateDTO stkCommonOperateDTO2 = this.getInvStkCommonOperateDTO(invAjDRespVOS, invAjDTO, InvStkSceneCodeEnum.INV_AJ_AJ001.getType());
                this.invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO2);
            } else if (UdcEnum.INV_AJ_TYPE_STKO.getValueCode().equals(invAjDTO.getDocType())) {
                this.createLot(invAjDTO, invAjDRespVOS);
                stkCommonOperateDTO = this.getInvStkCommonOperateDTO(invAjDRespVOS, invAjDTO, InvStkSceneCodeEnum.INV_AJ_AJ001.getType());
                this.invStkOptBizService.invStkCommonOperate(stkCommonOperateDTO);
            }
            invAjDTO.setId(invAjDTO.getId());
            invAjDTO.setDocStatus(UdcEnum.INV_AJ_STATUS_CF.getValueCode());
            invAjDTO.setIoDate(LocalDateTime.now());
            this.update(invAjDTO);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long submitOneInvAj(InvAjSaveVO invAjSaveVO) {
        invAjSaveVO.setLotFlag(true);
        Long id = invAjSaveVO.getId();
        Long masId = null;
        InvAjDTO invAjDTO = new InvAjDTO();
        this.transactionTemplate.setPropagationBehavior(3);
        if (id != null) {
            invAjDTO = this.invAjDomainService.findById(id);
            if (Objects.isNull(invAjDTO)) {
                throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u4e0d\u5b58\u5728,\u65e0\u6cd5\u63d0\u4ea4");
            }
            if (UdcEnum.INV_AJ_STATUS_DR.getValueCode().equals(invAjDTO.getDocStatus()) || UdcEnum.INV_AJ_STATUS_RJ.getValueCode().equals(invAjDTO.getDocStatus())) {
                this.saveOneInvAj(invAjSaveVO);
                invAjDTO = InvAjConvert.INSTANCE.invAjSaveVOToInvAjDTO(invAjSaveVO);
                invAjDTO.setProcInstId(invAjDTO.getProcInstId());
                invAjDTO.setProcInstStatus(invAjDTO.getProcInstStatus());
            } else {
                throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u72b6\u6001\u5f02\u5e38\uff0c\u53ea\u6709\u8349\u7a3f\u548c\u62d2\u7edd\u72b6\u6001\u5355\u636e\u624d\u53ef\u63d0\u4ea4");
            }
        }
        if (id == null) {
            masId = (Long)this.transactionTemplate.execute(transactionStatus -> {
                try {
                    Long aLong = this.saveOneInvAj(invAjSaveVO);
                    return aLong;
                }
                catch (RuntimeException e) {
                    transactionStatus.setRollbackOnly();
                    throw new BusinessException(ApiCode.FAIL, e.getMessage());
                }
            });
            invAjDTO = this.invAjDomainService.findById(masId);
        }
        OrgOuRpcDTO orgOuRpcDTO1 = this.orgOutService.findOuById(invAjSaveVO.getOuId());
        OrgOuRpcDTO orgOuRpcDTO = new OrgOuRpcDTO();
        orgOuRpcDTO.setOuCode("100010");
        orgOuRpcDTO.setOuType("10");
        if (ObjectUtils.isEmpty((Object)orgOuRpcDTO)) {
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u652f\u6491\u57df\u516c\u53f8\u5931\u8d25\uff0c\u516c\u53f8\u7f16\u53f7\u4e3a\uff1a" + invAjSaveVO.getOuId());
        }
        if (orgOuRpcDTO.getOuType() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u652f\u6491\u57df\u516c\u53f8\u7c7b\u578b\u5931\u8d25\uff0c\u516c\u53f8\u7f16\u53f7\u4e3a\uff1a" + invAjSaveVO.getOuId());
        }
        if (StringUtils.isEmpty((Object)invAjDTO.getReasonCode())) {
            throw new BusinessException(ApiCode.FAIL, "\u539f\u56e0\u7801\u4e3a\u7a7a\uff0c\u5355\u53f7\uff1a{}\uff1a" + invAjSaveVO.getDocNo());
        }
        try {
            List invAjSpis = SpringFactoriesLoader.loadFactories(InvAjSpi.class, null);
            if (!CollectionUtils.isEmpty((Collection)invAjSpis)) {
                for (InvAjSpi invAjSpi : invAjSpis) {
                    InvAjVO invAjVO = new InvAjVO();
                    BeanCopyUtil.beanCopyWithIngore(invAjDTO, invAjVO, BeanCopyUtil.getNullAndIgnorePropertyNames(invAjDTO, new String[0]));
                    invAjSpi.submitAjCallBack(this.workflowService, this.jpaQueryFactory, id, invAjVO);
                }
            }
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "\u542f\u52a8\u5de5\u4f5c\u6d41\u5931\u8d25\uff1a" + e.getMessage());
        }
        return invAjDTO.getId();
    }

    private void stratLock(Long masId, InvAjSaveVO invAjSaveVO) {
        InvAjDTO invAjDTO = this.findIdOne(masId);
        if (Objects.nonNull(invAjDTO)) {
            List<InvAjDRespVO> invAjDVOS;
            List<InvStkCommon37InSaveVO> invStkCommon37InSaveVOS;
            if (invAjSaveVO.isLotFlag()) {
                InvAjDTO ajDTO = InvAjConvert.INSTANCE.invAjSaveVOToInvAjDTO(invAjSaveVO);
                invAjDTO.setDocStatus(UdcEnum.INV_AJ_STATUS_APPING.getValueCode());
                ajDTO.setDocStatus(UdcEnum.INV_AJ_STATUS_APPING.getValueCode());
                this.update(ajDTO);
            }
            if (!CollectionUtils.isEmpty(invStkCommon37InSaveVOS = this.convertCommon37InVO(invAjDVOS = this.invAjDDomainService.findByMasId(invAjDTO.getId()), invAjDTO, InvStk28Enum.T_TYPE_22))) {
                this.invStkCommonService.invStkCommon37(invStkCommon37InSaveVOS);
            }
        }
    }

    private void stratLock2(Long masId, InvAjSaveVO invAjSaveVO) {
        InvAjDTO invAjDTO = this.findIdOne(masId);
        if (Objects.nonNull(invAjDTO)) {
            if (invAjSaveVO.isLotFlag()) {
                InvAjDTO ajDTO = InvAjConvert.INSTANCE.invAjSaveVOToInvAjDTO(invAjSaveVO);
                invAjDTO.setDocStatus(UdcEnum.INV_AJ_STATUS_APPING.getValueCode());
                ajDTO.setDocStatus(UdcEnum.INV_AJ_STATUS_APPING.getValueCode());
                this.update(ajDTO);
            }
            List<InvAjDRespVO> invAjDVOS = this.invAjDDomainService.findByMasId(invAjDTO.getId());
            InvStkCommonOperateDTO operateDTO = this.getInvStkCommonOperateDTO(invAjDVOS, invAjDTO, InvStkSceneCodeEnum.INV_AJ_AJ002.getType());
            this.invStkOptBizService.invStkCommonOperate(operateDTO);
        }
    }

    private InvStkCommonOperateDTO getInvStkCommonOperateDTO(List<InvAjDRespVO> invAjDRespVOS, InvAjDTO invAjDTO, String sceneCode) {
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-", ""));
        operateDTO.setSceneCode(sceneCode);
        operateDTO.setSource("YST-INV");
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<InvStkCommonOperateBodyDTO>();
        invAjDRespVOS.stream().forEach(invAjDSaveVO -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invAjDSaveVO.getWhId());
            operateBodyDTO.setItemId(invAjDSaveVO.getItemId());
            operateBodyDTO.setDeter2(invAjDSaveVO.getDeter2());
            operateBodyDTO.setSrcDocId(invAjDTO.getId());
            operateBodyDTO.setDocNo(invAjDTO.getDocNo());
            operateBodyDTO.setSrcDocDid(invAjDSaveVO.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKAJ.getValueCode());
            operateBodyDTO.setLineNo(invAjDSaveVO.getLineNo());
            operateBodyDTO.setCreateUserId(invAjDTO.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invAjDSaveVO.getUom());
            operateBodyDTO.setQty(invAjDSaveVO.getQty());
            operateBodyDTO.setLotNo(invAjDSaveVO.getLotNo());
            if (UdcEnum.INV_AJ_TYPE_STKIN.getValueCode().equals(invAjDTO.getDocType()) || UdcEnum.INV_AJ_TYPE_STKO.getValueCode().equals(invAjDTO.getDocType())) {
                operateBodyDTO.setLotNo(invAjDSaveVO.getToLotNo());
            }
            if (UdcEnum.INV_AJ_TYPE_STKOUT.getValueCode().equals(invAjDTO.getDocType())) {
                operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKOUT.getValueCode());
            }
            operateBodyDTO.setPCode(invAjDSaveVO.getPCode());
            operateBodyDTO.setPType(invAjDSaveVO.getPType());
            operateBodyDTO.setOuId(invAjDTO.getOuId());
            operateBodyDTO.setVariId(invAjDSaveVO.getVariId());
            operateBodyDTOS.add(operateBodyDTO);
        });
        operateDTO.setSourceBodyList(operateBodyDTOS);
        return operateDTO;
    }

    public void chiocSign(OrgOuRpcDTO orgOuRpcDTO, SysUserDTO user, Long id, InvAjDTO invAjDTO, int sign) {
        if (id == null || invAjDTO.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(invAjDTO.getProcInstStatus())) {
            String procInstName = "\u5e93\u5b58\u8c03\u6574:" + invAjDTO.getDocNo();
            String procDefKeyName = ProcDefKey.INV_ADJST.name();
            this.startFile(procDefKeyName, invAjDTO, procInstName, user);
        }
    }

    public void startFile(String procDefKeyName, InvAjDTO invAjDTO, String procInstName, SysUserDTO user) {
        WorkflowResult processInfoWorkflowResult = this.workflowService.startProcess(StartProcessPayload.of((String)procDefKeyName, (String)procInstName, (String)("" + invAjDTO.getId()), null));
        if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
            throw new BusinessException("\u8c03\u7528\u5de5\u4f5c\u6d41\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f:" + processInfoWorkflowResult.getMsg());
        }
        QInvAjDO qInvAjDO = QInvAjDO.invAjDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qInvAjDO).set((Path)qInvAjDO.procInstId, (Object)((ProcessInfo)processInfoWorkflowResult.getData()).getProcInstId()).set(qInvAjDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{qInvAjDO.id.eq((Object)invAjDTO.getId())});
        if (!Objects.equals(((ProcessInfo)processInfoWorkflowResult.getData()).getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(qInvAjDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
            jpaUpdateClause.set((Path)qInvAjDO.docStatus, (Object)UdcEnum.PUR_PO_STATUS_APPING.getValueCode());
        }
        jpaUpdateClause.execute();
    }

    private void createLot(InvAjDTO invAjDTO, List<InvAjDRespVO> invAjDRespVOS) {
        ArrayList<InvLotSaveVO> invLots = new ArrayList<InvLotSaveVO>();
        List<InvLotCommon21InVO> invLotCommon21InVOS = invAjDRespVOS.stream().map(grd -> {
            InvLotCommon21InVO invLotCommon21InVO = new InvLotCommon21InVO();
            invLotCommon21InVO.setItemId(grd.getItemId());
            invLotCommon21InVO.setVariId(grd.getVariId());
            invLotCommon21InVO.setLotNo(grd.getToLotNo());
            invLotCommon21InVO.setOuId(invAjDTO.getOuId());
            return invLotCommon21InVO;
        }).collect(Collectors.toList());
        Map<Integer, List<InvLotRespVO>> invLotVOMap = this.invLotCommonService.getInvLotVOList(invLotCommon21InVOS);
        invAjDRespVOS.forEach(grd -> {
            if (invLotVOMap.get(invAjDRespVOS.indexOf(grd)) != null && ((List)invLotVOMap.get(invAjDRespVOS.indexOf(grd))).size() != 0) {
                return;
            }
            InvLotSaveVO invLotSaveVO = new InvLotSaveVO();
            invLotSaveVO.setOuId(invAjDTO.getOuId());
            invLotSaveVO.setItemId(grd.getItemId());
            invLotSaveVO.setManuDate(grd.getManuDate());
            invLotSaveVO.setExpireDate(grd.getExpireDate());
            if (grd.getExpireDate() != null) {
                invLotSaveVO.setUntilExpireDays((int)(grd.getExpireDate().toLocalDate().toEpochDay() - LocalDate.now().toEpochDay()));
            }
            invLotSaveVO.setLotNo(grd.getToLotNo());
            invLotSaveVO.setMenuLotNo(grd.getMenuLotNo());
            invLotSaveVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKAJ.getValueCode());
            invLotSaveVO.setSrcDocId(invAjDTO.getId());
            invLotSaveVO.setSrcDocNo(invAjDTO.getDocNo());
            invLotSaveVO.setSrcDocDid(grd.getId());
            invLotSaveVO.setVariId(grd.getVariId());
            invLotSaveVO.setMenuLotNo(grd.getMenuLotNo());
            invLots.add(invLotSaveVO);
        });
        if (!CollectionUtils.isEmpty(invLots)) {
            this.invLotCommonService.createInvLotInfo(invLots);
        }
    }

    public InvAjDTO findIdOne(Long id) {
        Optional<InvWhDO> temp;
        InvAjDTO invAjDTO = this.invAjDomainService.findById(id);
        if (Objects.nonNull(invAjDTO) && (temp = this.invWhDomainService.findById(invAjDTO.getWhId())).isPresent()) {
            invAjDTO.setWhCode(temp.get().getWhCode());
        }
        return invAjDTO;
    }

    private InvStkCommon28InSaveVO setInvStkCommon28InVO(InvAjDTO invAjDTO, InvAjDRespVO invAjDRespVO) {
        InvStkCommon28InSaveVO invStkCommon28InSaveVO = new InvStkCommon28InSaveVO();
        invStkCommon28InSaveVO.setDocNo(invAjDTO.getDocNo());
        invStkCommon28InSaveVO.setLineNo(invAjDRespVO.getLineNo());
        invStkCommon28InSaveVO.setOpDate(invAjDTO.getApplyDate());
        invStkCommon28InSaveVO.setCreateUserId(invAjDTO.getApplyEmpId());
        invStkCommon28InSaveVO.setInvStk28Enum2(null);
        invStkCommon28InSaveVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKAJ.getValueCode());
        invStkCommon28InSaveVO.setSrcDocId(invAjDTO.getId());
        invStkCommon28InSaveVO.setSrcDocDid(invAjDRespVO.getId());
        invStkCommon28InSaveVO.setItemId(invAjDRespVO.getItemId());
        invStkCommon28InSaveVO.setVariId(invAjDRespVO.getVariId());
        invStkCommon28InSaveVO.setWhId(invAjDTO.getWhId());
        invStkCommon28InSaveVO.setPCode(invAjDRespVO.getPCode());
        invStkCommon28InSaveVO.setPType(invAjDRespVO.getPType());
        invStkCommon28InSaveVO.setDeter1(invAjDRespVO.getDeter1());
        invStkCommon28InSaveVO.setDeter2(invAjDRespVO.getDeter2());
        invStkCommon28InSaveVO.setDeter3(invAjDRespVO.getDeter3());
        invStkCommon28InSaveVO.setLotNo(invAjDRespVO.getLotNo());
        invStkCommon28InSaveVO.setReasonCode(invAjDTO.getReasonCode());
        return invStkCommon28InSaveVO;
    }

    @Override
    public List<InvStkCommon37InSaveVO> convertCommon37InVO(List<InvAjDRespVO> invAjDRespVOS, InvAjDTO invAjDTO, InvStk28Enum invStk28Enum) {
        ArrayList<InvStkCommon37InSaveVO> invStkCommon37InSaveVOS = new ArrayList<InvStkCommon37InSaveVO>();
        invAjDRespVOS.forEach(invAjDRespVO -> {
            InvStkCommon37InSaveVO invStkCommon37InSaveVO = this.setInvStkCommon37InVO(invAjDTO, (InvAjDRespVO)invAjDRespVO);
            invStkCommon37InSaveVO.setInvStk28Enum1(invStk28Enum);
            if (UdcEnum.INV_AJ_TYPE_LOT.getValueCode().equals(invAjDTO.getDocType()) || UdcEnum.INV_AJ_TYPE_DES.getValueCode().equals(invAjDTO.getDocType())) {
                invStkCommon37InSaveVOS.add(invStkCommon37InSaveVO);
            }
            if (UdcEnum.INV_AJ_TYPE_STKOUT.getValueCode().equals(invAjDTO.getDocType())) {
                invStkCommon37InSaveVOS.add(invStkCommon37InSaveVO);
            }
        });
        return invStkCommon37InSaveVOS;
    }

    private InvStkCommon37InSaveVO setInvStkCommon37InVO(InvAjDTO invAjDTO, InvAjDRespVO invAjDRespVO) {
        InvStkCommon37InSaveVO invStkCommon37InSaveVO = new InvStkCommon37InSaveVO();
        invStkCommon37InSaveVO.setDocNo(invAjDTO.getDocNo());
        invStkCommon37InSaveVO.setQty(invAjDRespVO.getQty());
        invStkCommon37InSaveVO.setLineNo(invAjDRespVO.getLineNo());
        invStkCommon37InSaveVO.setOpDate(invAjDTO.getIoDate());
        invStkCommon37InSaveVO.setCreateUserId(invAjDTO.getCreateUserId());
        invStkCommon37InSaveVO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKAJ.getValueCode());
        invStkCommon37InSaveVO.setSrcDocId(invAjDTO.getId());
        invStkCommon37InSaveVO.setSrcDocDid(invAjDRespVO.getId());
        invStkCommon37InSaveVO.setInvStk28Enum2(null);
        invStkCommon37InSaveVO.setPCode(invAjDRespVO.getPCode());
        invStkCommon37InSaveVO.setPType(invAjDRespVO.getPType());
        invStkCommon37InSaveVO.setDeter1(invAjDRespVO.getDeter1());
        invStkCommon37InSaveVO.setDeter2(invAjDRespVO.getDeter2());
        invStkCommon37InSaveVO.setDeter3(invAjDRespVO.getDeter3());
        invStkCommon37InSaveVO.setItemId(invAjDRespVO.getItemId());
        invStkCommon37InSaveVO.setVariId(invAjDRespVO.getVariId());
        invStkCommon37InSaveVO.setLotNo(invAjDRespVO.getLotNo());
        invStkCommon37InSaveVO.setWhId(invAjDTO.getWhId());
        invStkCommon37InSaveVO.setUom(invAjDRespVO.getUom());
        invStkCommon37InSaveVO.setReasonCode(invAjDTO.getReasonCode());
        return invStkCommon37InSaveVO;
    }

    private Integer getExpireDays(InvAjDRespVO invAjDRespVO) {
        Integer expireDays = null;
        ArrayList<CallSite> param = new ArrayList<CallSite>();
        param.add((CallSite)((Object)(invAjDRespVO.getItemId() + "_" + invAjDRespVO.getLotNo())));
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(Arrays.asList(invAjDRespVO.getItemId()));
        List<ItmItemRpcDTO> itmItemDTOS = this.itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        if (!CollectionUtils.isEmpty(itmItemDTOS) && itmItemDTOS.get(0).getGuaranteeDays() != null) {
            return itmItemDTOS.get(0).getGuaranteeDays();
        }
        return expireDays;
    }

    private BigDecimal getAvalQty(InvAjDRespVO invAjDRespVO) {
        InvBaseModel invStkParam = new InvBaseModel();
        invStkParam.setItemId(invAjDRespVO.getItemId());
        invStkParam.setWhId(invAjDRespVO.getWhId());
        invStkParam.setVariId(invAjDRespVO.getVariId());
        invStkParam.setLotNo(invAjDRespVO.getLotNo());
        invStkParam.setDeter1(invAjDRespVO.getDeter1());
        invStkParam.setDeter2(invAjDRespVO.getDeter2());
        invStkParam.setPCode(invAjDRespVO.getPCode());
        invStkParam.setPType(invAjDRespVO.getPType());
        invStkParam.setDeter3(invAjDRespVO.getDeter3());
        InvStkRespVO invStk = this.invStkCommonService.getInvStk(invStkParam);
        if (invStk != null) {
            return invStk.getAvalQty();
        }
        return null;
    }

    private String getUdcDesc(String domain, String udcCode, String udcVal) {
        if (StringUtils.isEmpty((Object)udcVal) || StringUtils.isEmpty((Object)domain) || StringUtils.isEmpty((Object)udcCode)) {
            return null;
        }
        Map<String, String> codeMap = this.systemService.sysUdcGetCodeMap(domain, udcCode);
        if (CollectionUtils.isEmpty(codeMap)) {
            return null;
        }
        if (codeMap.containsKey(udcVal)) {
            return codeMap.get(udcVal);
        }
        return null;
    }

    private void fillUpNameList(List<InvAjDTO> vos) {
        List<Long> whIds = vos.stream().map(InvAjDTO::getWhId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> userIds = vos.stream().map(InvAjDTO::getApplyEmpId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        Map<String, String> docTypeMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_AJ_TYPE_LOT.getModel(), UdcEnum.INV_AJ_TYPE_LOT.getCode());
        Map<String, String> docStatusMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_AJ_STATUS_DR.getModel(), UdcEnum.INV_AJ_STATUS_DR.getCode());
        Map<String, String> reasonMap = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_REASON_CODE_119.getModel(), UdcEnum.COM_REASON_CODE_119.getCode());
        List<String> deter2s = vos.stream().filter(f -> f.getDeter2() != null).map(InvAjDTO::getDeter2).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        InvWhAreaParamVO whAreaParamVO = new InvWhAreaParamVO();
        whAreaParamVO.setWhIds(whIds);
        whAreaParamVO.setDeter2s(deter2s);
        List<InvWhAreaRespVO> whAreaRespVOS = this.invWhAreaService.findWhAreasByParam(whAreaParamVO);
        Map<String, String> apprStatusMap = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_APPR_STATUS_APPROVING.getModel(), UdcEnum.COM_APPR_STATUS_APPROVING.getCode());
        List<InvWhRespVO> orgSuppVOS = this.invWhDomainService.findIdBatch(whIds);
        List<SysUserVO> userVOS = this.systemService.findAllEmpsByIdIn(userIds);
        List<Long> ouIds = vos.stream().map(InvAjDTO::getOuId).filter(Objects::nonNull).collect(Collectors.toList());
        List<OrgOuRpcDTO> orgOuRpcDTOS = this.orgOutService.findOuByIds(ouIds);
        List<Long> buIds = vos.stream().map(InvAjDTO::getBuId).filter(Objects::nonNull).collect(Collectors.toList());
        List<OrgBuRpcDTO> orgBuRpcDTOS = this.orgOutService.findBuByIds(buIds);
        vos.stream().forEach(vo -> {
            Optional<InvWhRespVO> orgWhVO;
            if (!CollectionUtils.isEmpty((Collection)whAreaRespVOS)) {
                whAreaRespVOS.stream().filter(a -> a.getDeter2().equals(vo.getDeter2()) && a.getWhId().equals(vo.getWhId())).findAny().ifPresent(m -> vo.setDeter2Name(m.getDeter2Name()));
            }
            vo.setProcInstStatusName(vo.getProcInstStatus() != null ? vo.getProcInstStatus().getDesc() : null);
            if (!CollectionUtils.isEmpty((Collection)orgOuRpcDTOS)) {
                orgOuRpcDTOS.stream().filter(u -> u.getId().equals(vo.getOuId())).findAny().ifPresent(i -> {
                    vo.setOuCode(i.getOuCode());
                    vo.setOuName(i.getOuName());
                });
            }
            if (!CollectionUtils.isEmpty((Collection)orgBuRpcDTOS)) {
                orgBuRpcDTOS.stream().filter(b -> b.getId().equals(vo.getBuId())).findAny().ifPresent(i -> vo.setBuName(i.getBuName()));
            }
            if ((orgWhVO = orgSuppVOS.stream().filter(v -> v.getId().equals(vo.getWhId())).findFirst()).isPresent()) {
                InvWhRespVO whVO = orgWhVO.get();
                vo.setWhCode(whVO.getWhCode());
                vo.setWhName(whVO.getWhName());
                vo.setWhType(whVO.getWhType());
            }
            if (!CollectionUtils.isEmpty((Collection)userVOS)) {
                userVOS.stream().filter(u -> u.getId().equals(vo.getApplyEmpId())).findAny().ifPresent(i -> vo.setApplyEmpName(i.getUsername()));
            }
            if (!CollectionUtils.isEmpty((Map)docTypeMap) && docTypeMap.containsKey(vo.getDocType())) {
                vo.setDocTypeName((String)docTypeMap.get(vo.getDocType()));
            }
            if (!CollectionUtils.isEmpty((Map)docStatusMap) && docStatusMap.containsKey(vo.getDocStatus())) {
                vo.setDocStatusName((String)docStatusMap.get(vo.getDocStatus()));
            }
            if (!CollectionUtils.isEmpty((Map)reasonMap) && reasonMap.containsKey(vo.getReasonCode())) {
                vo.setReasonCodeName((String)reasonMap.get(vo.getReasonCode()));
            }
            if (!CollectionUtils.isEmpty((Map)apprStatusMap) && apprStatusMap.containsKey(vo.getApprStatus())) {
                vo.setApprStatusName((String)apprStatusMap.get(vo.getApprStatus()));
            }
        });
    }

    private Long saveInvAj(InvAjSaveVO invAjSaveVO) {
        InvAj invAj = InvAjConvert.INSTANCE.invAjSaveVOToInvAj(invAjSaveVO);
        Long masId = invAj.getId();
        invAj.setDocStatus(invAjSaveVO.getDocStatus() == null ? UdcEnum.INV_AJ_STATUS_DR.getValueCode() : invAjSaveVO.getDocStatus());
        if (masId != null) {
            InvAjDTO invAjDTO = this.invAjDomainService.findById(masId);
            if (Objects.nonNull(invAjDTO)) {
                if (!UdcEnum.INV_AJ_STATUS_DR.getValueCode().equals(invAj.getDocStatus()) && !UdcEnum.INV_AJ_STATUS_RJ.getValueCode().equals(invAj.getDocStatus())) {
                    throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u72b6\u6001\u5f02\u5e38\uff0c\u65e0\u6cd5\u518d\u6b21\u4fdd\u5b58");
                }
                this.update(invAjDTO);
                this.invAjDDomainService.deleteByMasId(masId);
            } else {
                invAj.setDocNo(this.getInvAjDocNo(invAjSaveVO));
                masId = this.invAjDomainService.createInvAj(invAj);
            }
        } else {
            invAj.setDocNo(this.getInvAjDocNo(invAjSaveVO));
            masId = this.invAjDomainService.createInvAj(invAj);
        }
        return masId;
    }

    private String getInvAjDocNo(InvAjSaveVO invAjSaveVO) {
        if (invAjSaveVO.getOuCode() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a\uff0c\u8c03\u7528\u7cfb\u7edf\u57df\u670d\u52a1\u516c\u53f8\u67e5\u8be2\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5");
        }
        String docNo = null;
        if (UdcEnum.INV_AJ_TYPE_LOT.getValueCode().equals(invAjSaveVO.getDocType())) {
            docNo = this.systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_IE.getCode(), List.of(invAjSaveVO.getOuCode()));
        } else if (UdcEnum.INV_AJ_TYPE_DES.getValueCode().equals(invAjSaveVO.getDocType())) {
            docNo = this.systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_ID.getCode(), List.of(invAjSaveVO.getOuCode()));
        } else if (UdcEnum.INV_AJ_TYPE_STKIN.getValueCode().equals(invAjSaveVO.getDocType()) || UdcEnum.INV_AJ_TYPE_STKO.getValueCode().equals(invAjSaveVO.getDocType())) {
            docNo = this.systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_IA.getCode(), List.of(invAjSaveVO.getOuCode()));
        } else if (UdcEnum.INV_AJ_TYPE_STKOUT.getValueCode().equals(invAjSaveVO.getDocType())) {
            docNo = this.systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_IB.getCode(), List.of(invAjSaveVO.getOuCode()));
        }
        return docNo;
    }

    private void saveInvAjDVOS(InvAjSaveVO createParam, Long masId) {
        if (!CollectionUtils.isEmpty(createParam.getInvAjDSaveVOList())) {
            List<InvAjDSaveVO> invAjDSaveVOS = createParam.getInvAjDSaveVOList();
            Long finalMasId = masId;
            AtomicDouble linoNo = new AtomicDouble(0.0);
            List<InvAjD> invAjDList = invAjDSaveVOS.stream().map(d -> {
                InvAjD invAjD = InvAjDConvert.INSTANCE.invAjDSaveVOToInvAjD((InvAjDSaveVO)d);
                invAjD.setMasId(finalMasId);
                invAjD.setLineNo(linoNo.addAndGet(1.0));
                invAjD.setCreateTime(LocalDateTime.now());
                if ((createParam.getSourceFlag() == null ? 0 : createParam.getSourceFlag()) == 1 && UdcEnum.INV_AJ_TYPE_STKIN.getValueCode().equals(createParam.getDocType()) && createParam.getDeter2().equals(UdcEnum.INV_FUNC_TYPE_13.getValueCode())) {
                    invAjD.setDeter2(UdcEnum.INV_FUNC_TYPE_13.getValueCode());
                    invAjD.setReasonCode(UdcEnum.COM_REASON_CODE_119.getValueCode());
                }
                if (createParam.getDocType().equals(UdcEnum.INV_AJ_TYPE_STKIN.getValueCode())) {
                    invAjD.setLotNo(invAjD.getToLotNo());
                }
                this.verifyAjDAuthority(createParam, invAjD);
                return invAjD;
            }).collect(Collectors.toList());
            this.invAjDDomainService.saveAll(invAjDList);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(InvAjDTO invAjDTO) {
        if (!Objects.nonNull(invAjDTO)) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + invAjDTO.getId());
        }
        InvAj invAj = InvAjConvert.INSTANCE.invAjDTOToInvAj(invAjDTO);
        this.invAjDomainService.createInvAj(invAj);
    }

    private void verifyAjDAuthority(InvAjSaveVO createParam, InvAjD invAjDDO) {
        try {
            invAjDDO.setSecBuId(createParam.getSecBuId() == null ? null : createParam.getSecBuId());
            invAjDDO.setSecOuId(createParam.getOuId() == null ? null : createParam.getOuId());
        }
        catch (Exception e) {
            log.error("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\uff0c\u8bf7\u5148\u767b\u5f55\uff1a{}" + e.getMessage());
        }
    }

    private void checkInvAjQty(InvAjSaveVO invAjSaveVO) {
        invAjSaveVO.getInvAjDSaveVOList().stream().forEach(i -> {
            InvRoCommon30InSaveVO param = new InvRoCommon30InSaveVO();
            param.setItemId(i.getItemId());
            param.setLotNo(i.getLotNo());
            param.setWhId(i.getWhId());
            param.setDeter2(i.getDeter2());
            param.setQty(i.getQty());
            param.setUom(i.getUom());
            param.setDocStatus(UdcEnum.INV_RO_STATUS_APPED.getValueCode());
            if (!invAjSaveVO.getDocType().equals(UdcEnum.INV_AJ_TYPE_STKO.getValueCode()) && !invAjSaveVO.getDocType().equals(UdcEnum.INV_AJ_TYPE_STKIN.getValueCode()) && this.checkInvStkExist(param).booleanValue()) {
                throw new BusinessException(ApiCode.FAIL, "\u5e93\u5b58\u53ef\u4f9b\u91cf\u4e0d\u8db3\uff01");
            }
        });
    }

    public Boolean checkInvStkExist(InvRoCommon30InSaveVO queryParam) {
        InvBaseModel stkParam = new InvBaseModel();
        stkParam.setItemId(queryParam.getItemId());
        stkParam.setLotNo(queryParam.getLotNo());
        stkParam.setWhId(queryParam.getWhId());
        stkParam.setDeter2(queryParam.getDeter2());
        stkParam.setPCode(queryParam.getPCode());
        stkParam.setPType(queryParam.getPType());
        stkParam.setLimit1(queryParam.getLimit1());
        stkParam.setLimit2(queryParam.getLimit2());
        InvStkRespVO invStk = this.invStkService.getInvStk(stkParam);
        if (invStk == null) {
            return true;
        }
        if (invStk.getAvalQty().compareTo(queryParam.getQty()) >= 0) {
            return false;
        }
        return true;
    }

    private void whVerify(List<InvAjDSaveVO> invAjDSaveVOList) {
        long count = invAjDSaveVOList.stream().map(ajd -> ajd.getItemId() + "_" + ajd.getWhId() + "_" + ajd.getDeter2() + "_" + ajd.getLotNo() + "_" + ajd.getPCode() + "-" + ajd.getLimit1() + "-" + ajd.getLimit2()).distinct().count();
        if (count != (long)invAjDSaveVOList.size()) {
            throw new BusinessException("\u660e\u7ec6\u6570\u636e\u53c2\u6570\u9519\u8bef\uff0c\u5546\u54c1\u7f16\u7801,\u540c\u4e00\u4ed3\u5e93\uff0c\u540c\u4e00\u5e93\u533a \u6216 \u540c\u4e00\u4ed3\u5e93\uff0c\u540c\u4e00\u5e93\u533a\uff0c\u540c\u4e00\u6279\u6b21\u5b58\u5728\u76f8\u540c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
        }
        invAjDSaveVOList.forEach(i -> {
            List whAreaRespVOS;
            InvWhAreaParamVO areaParamVO = new InvWhAreaParamVO();
            areaParamVO.setWhId(i.getWhId());
            areaParamVO.setDeter2(i.getDeter2());
            List<InvWhAreaRespVO> invWhAreaRespVOList = this.invWhAreaService.findWhAreasByParam(areaParamVO);
            if (CollectionUtils.isEmpty(invWhAreaRespVOList)) {
                throw new BusinessException(ApiCode.FAIL, String.format("\u8be5\u4ed3\u5e93\u6ca1\u6709\u529f\u80fd\u5e93\u533a[%s],\u8bf7\u68c0\u67e5\u6570\u636e\uff01", i.getWhName(), i.getDeter2Name()));
            }
            if (i.getPType() != null && i.getPCode() != null && CollectionUtils.isEmpty(whAreaRespVOS = invWhAreaRespVOList.stream().filter(v -> i.getPCode().equals(v.getPCode()) && i.getPType().equals(v.getPType())).collect(Collectors.toList()))) {
                throw new BusinessException(ApiCode.FAIL, String.format("\u8be5\u4ed3\u5e93\u529f\u80fd\u5e93\u533a\u3010%s\u3011\u4e2d,\u5e93\u5b58\u5408\u4f5c\u4f19\u4f34\u3010%s\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u914d\u7f6e\uff01", i.getDeter2Name(), i.getPCode()));
            }
        });
    }

    public InvAjServiceImpl(JPAQueryFactory jpaQueryFactory, InvAjDomainService invAjDomainService, InvAjDDomainService invAjDDomainService, SystemService systemService, TransactionTemplate transactionTemplate, WorkflowService workflowService, InvWhAreaService invWhAreaService, ItmOutService itmOutService, InvStkCommonService invStkCommonService, OrgOutService orgOutService, InvWhDomainService invWhDomainService, InvStkService invStkService, InvLotCommonService invLotCommonService, InvLotService invLotService, InvStkOptBizService invStkOptBizService) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.invAjDomainService = invAjDomainService;
        this.invAjDDomainService = invAjDDomainService;
        this.systemService = systemService;
        this.transactionTemplate = transactionTemplate;
        this.workflowService = workflowService;
        this.invWhAreaService = invWhAreaService;
        this.itmOutService = itmOutService;
        this.invStkCommonService = invStkCommonService;
        this.orgOutService = orgOutService;
        this.invWhDomainService = invWhDomainService;
        this.invStkService = invStkService;
        this.invLotCommonService = invLotCommonService;
        this.invLotService = invLotService;
        this.invStkOptBizService = invStkOptBizService;
    }
}

