/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkSsQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkSsRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvStkSsService;
import com.elitesland.yst.production.inv.application.service.InvWhService;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvStkSsConvert;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvStkSsDO;
import com.elitesland.yst.production.inv.domain.service.InvStkDomainService;
import com.elitesland.yst.production.inv.domain.service.InvStkSsDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvStkDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkSsDTO;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvStkSsServiceImpl
implements InvStkSsService {
    private static final Logger log = LoggerFactory.getLogger(InvStkSsServiceImpl.class);
    private final InvStkSsDomainService invStkSsDomainService;
    private final InvWhService invWhService;
    private final ItmOutService itmOutService;
    private final OrgOutService outouService;
    private final SystemService systemService;
    private final InvStkDomainService invStkDomainService;
    private final InvWhAreaDomainService invWhAreaDomainService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private TenantClientProvider tenantClientProvider;

    @Override
    @SysCodeProc
    public PagingVO<InvStkSsRespVO> findStkSsPage(InvStkSsQueryParamVO param) {
        PagingVO<InvStkSsDTO> pagingVo;
        if (!CollectionUtils.isEmpty(param.getBrands()) || StringUtils.hasLength((String)param.getItemType()) || StringUtils.hasLength((String)param.getItemType2())) {
            ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
            itmItemPartParam.setBrands(param.getBrands());
            itmItemPartParam.setItemType(param.getItemType());
            itmItemPartParam.setItemType2(param.getItemType2());
            List<Long> brandItemIds = this.itmOutService.findItemIdByParam(itmItemPartParam).stream().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(brandItemIds)) {
                return PagingVO.builder().total(0L).records(new ArrayList()).build();
            }
            param.setItemIds(brandItemIds);
        }
        if (CollectionUtils.isEmpty((Collection)(pagingVo = this.invStkSsDomainService.findStkSs(param)).getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List vos = pagingVo.getRecords();
        List<InvStkSsRespVO> invStkSsRespVOS = vos.stream().map(InvStkSsConvert.INSTANCE::dtoToRespVO).collect(Collectors.toList());
        this.stkGroupResults(invStkSsRespVOS);
        return PagingVO.builder().total(pagingVo.getTotal()).records(invStkSsRespVOS).build();
    }

    @Override
    public void createStkSs(LocalDateTime ssTime, TenantDataIsolateProvider tenantDataIsolateProvider) {
        ssTime = Objects.isNull(ssTime) ? LocalDateTime.now() : ssTime;
        List<InvStkSsDO> invStkDTOS = this.tesk(ssTime, tenantDataIsolateProvider);
        log.info("\u83b7\u53d6\u6570\u636e\u5e93\u6570\u636e{}", (Object)JSON.toJSONString(invStkDTOS));
        if (CollectionUtils.isEmpty(invStkDTOS)) {
            log.info("\u672a\u67e5\u8be2\u5230\u5e93\u5b58\u6570\u636e!");
        } else {
            this.invStkSsDomainService.saveInvStkList(invStkDTOS);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<InvStkSsDO> tesk(LocalDateTime ssTime, TenantDataIsolateProvider tenantDataIsolateProvider) {
        InvStkQueryParamVO invStkQueryParamVO = new InvStkQueryParamVO();
        invStkQueryParamVO.setCurrent(1);
        invStkQueryParamVO.setSize(1);
        PagingVO<InvStkDTO> pagingVO = this.invStkDomainService.queryAll(invStkQueryParamVO);
        int total = (int)pagingVO.getTotal();
        SysTenantDTO sessionTenant = this.tenantClientProvider.getSessionTenant();
        List<InvStkQueryParamVO> invStkQueryParamVOS = this.splitList(total, 1000);
        ArrayList<InvStkSsDO> need = new ArrayList<InvStkSsDO>();
        try {
            for (InvStkQueryParamVO voList : invStkQueryParamVOS) {
                CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.setNeed(voList, ssTime, tenantDataIsolateProvider, sessionTenant), (Executor)this.taskExecutor);
                try {
                    if (future == null) continue;
                    List invStkSsDOS = future.get();
                    need.addAll(invStkSsDOS);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new BusinessException("\u7ebf\u7a0b\u83b7\u53d6\u6570\u636e\u5931\u8d25:" + e.getMessage());
                    return need;
                }
            }
        }
        catch (Exception e) {
            log.error("\u591a\u7ebf\u7a0b\u6267\u884c\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u591a\u7ebf\u7a0b\u6267\u884c\u5931\u8d25:" + e.getMessage());
        }
    }

    private List<InvStkSsDO> setNeed(InvStkQueryParamVO paramVO, LocalDateTime ssTime, TenantDataIsolateProvider tenantDataIsolateProvider, SysTenantDTO sessionTenant) {
        return (List)tenantDataIsolateProvider.byTenantDirectly(() -> {
            List records = this.invStkDomainService.queryAll(paramVO).getRecords();
            return records.stream().map(stkDTO -> {
                InvStkSsDO invStkSsDO = InvStkSsConvert.INSTANCE.stkDtoToDO((InvStkDTO)stkDTO);
                invStkSsDO.setId(null);
                invStkSsDO.setStkSsTime(ssTime);
                return invStkSsDO;
            }).collect(Collectors.toList());
        }, sessionTenant);
    }

    private List<InvStkQueryParamVO> splitList(int length, int groupSize) {
        ArrayList<InvStkQueryParamVO> need = new ArrayList<InvStkQueryParamVO>();
        int u = length % groupSize;
        int i = 0;
        i = u > 0 ? length / groupSize + 1 : length / groupSize;
        if (i < 1 || i == 1) {
            InvStkQueryParamVO invStkQueryParamVO = new InvStkQueryParamVO();
            invStkQueryParamVO.setCurrent(1);
            invStkQueryParamVO.setSize(groupSize);
            need.add(invStkQueryParamVO);
        } else {
            for (int j = 0; j < i; ++j) {
                InvStkQueryParamVO invStkQueryParamVO = new InvStkQueryParamVO();
                invStkQueryParamVO.setSize(groupSize);
                invStkQueryParamVO.setCurrent(j + 1);
                need.add(invStkQueryParamVO);
            }
        }
        return need;
    }

    public void stkGroupResults(List<InvStkSsRespVO> invStkSsRespVOS) {
        List itemIds = invStkSsRespVOS.stream().map(InvStkSsRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(itemIds);
        List<ItmItemRpcDTO> itmItemResults = this.itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        List<Long> userIds = invStkSsRespVOS.stream().map(InvStkSsRespVO::getCreateUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SysUserVO> empsByIdIn = this.systemService.findAllEmpsByIdIn(userIds);
        List<Long> ouIds = invStkSsRespVOS.stream().map(InvStkSsRespVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<OrgOuRpcDTO> orgOuResults = this.outouService.findOuByIds(ouIds);
        invStkSsRespVOS.stream().forEach(i -> {
            if (!CollectionUtils.isEmpty((Collection)empsByIdIn)) {
                empsByIdIn.stream().filter(e -> e.getId().equals(i.getCreateUserId())).findAny().ifPresent(v -> i.setCreator(v.getUsername()));
            }
            itmItemResults.stream().filter(v -> v.getId().equals(i.getItemId())).findAny().ifPresent(m -> {
                i.setItemCode(m.getItemCode());
                i.setItemName(m.getItemName());
                i.setBrand(m.getBrand());
                i.setPackageSpec(m.getPackageSpec());
                i.setSpec(m.getSpec());
                i.setItemType(m.getItemType());
                i.setItemType2(m.getItemType2());
                i.setBrandName(m.getBrandName());
                i.setBarCode(m.getBarCode());
                i.setSuppCode(m.getSuppCode());
                i.setSuppName(m.getSuppName());
                i.setItemCatePathName(m.getItemCatePathName());
                if (m.getGuaranteeDays() != null) {
                    i.setExpireDays(m.getGuaranteeDays());
                }
            });
            orgOuResults.stream().filter(o -> o.getId().equals(i.getOuId())).findAny().ifPresent(m -> {
                i.setOuCode(m.getOuCode());
                i.setOuName(m.getOuName());
            });
            if (StringUtils.hasLength((String)i.getPCode()) && StringUtils.hasLength((String)i.getPType())) {
                InvParentParamVO paramVO = new InvParentParamVO();
                paramVO.setCode(i.getPCode());
                paramVO.setType(i.getPType());
                List<OrgRespVO> vos = this.outouService.findcodeAndName(paramVO);
                if (!CollectionUtils.isEmpty(vos)) {
                    i.setPName(vos.get(0).getName());
                }
            }
        });
    }

    public InvStkSsServiceImpl(InvStkSsDomainService invStkSsDomainService, InvWhService invWhService, ItmOutService itmOutService, OrgOutService outouService, SystemService systemService, InvStkDomainService invStkDomainService, InvWhAreaDomainService invWhAreaDomainService, TaskExecutor taskExecutor, TenantClientProvider tenantClientProvider) {
        this.invStkSsDomainService = invStkSsDomainService;
        this.invWhService = invWhService;
        this.itmOutService = itmOutService;
        this.outouService = outouService;
        this.systemService = systemService;
        this.invStkDomainService = invStkDomainService;
        this.invWhAreaDomainService = invWhAreaDomainService;
        this.taskExecutor = taskExecutor;
        this.tenantClientProvider = tenantClientProvider;
    }
}

