/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.web.controller.workflow;

import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.service.InvAjProcessService;
import com.elitesland.yst.production.inv.application.service.InvAjService;
import com.elitesland.yst.production.inv.application.service.InvAsmProcessService;
import com.elitesland.yst.production.inv.application.service.InvCkProcessService;
import com.elitesland.yst.production.inv.application.service.InvTrnProcessService;
import com.elitesland.yst.production.inv.domain.service.InvAsmDomainService;
import com.elitesland.yst.production.inv.domain.service.InvTrnDomainService;
import com.elitesland.yst.production.inv.enums.ProcDefKey;
import com.elitesland.yst.production.inv.infr.dto.InvAsmDTO;
import com.elitesland.yst.production.inv.infr.dto.InvTrnDTO;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvWorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(InvWorkflowCallBack.class);
    private final InvAjProcessService invAjProcessService;
    private final InvAjService invAjService;
    private final InvTrnProcessService invTrnProcessService;
    private final InvTrnDomainService invTrnService;
    private final InvAsmProcessService invAsmProcessService;
    private final OrgOutService orgOutService;
    private final InvCkProcessService invCkProcessService;
    private final InvAsmDomainService invAsmDomainService;

    public ArrayList<String> taskAssignee(String tenantId, String procDefKey, String taskKey, String businessKey, String customParams) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba: \u6d41\u7a0b\u5b9a\u4e49KEY:{},\u4efb\u52a1key:{},\u4e1a\u52a1key:{},\u81ea\u5b9a\u4e49\u53c2\u6570:{}", new Object[]{procDefKey, taskKey, businessKey, customParams});
        if (Objects.equals(procDefKey, ProcDefKey.INV_TRN.name())) {
            Long trnOuId = this.getTrnOuId(businessKey, customParams);
            ArrayList<String> userIds = this.invTrnProcessService.taskAssignee(trnOuId, customParams);
            return userIds;
        }
        if (Objects.equals(procDefKey, ProcDefKey.INV_ADJST.name())) {
            ArrayList<String> userIds = this.invAjProcessService.taskAssignee(null, customParams);
            return userIds;
        }
        if (Objects.equals(procDefKey, ProcDefKey.INV_ASM.name())) {
            Long asmOuId = this.getAsmOuId(businessKey, customParams);
            ArrayList<String> userIds = this.invAsmProcessService.taskAssignee(asmOuId, customParams);
            return userIds;
        }
        if (Objects.equals(procDefKey, ProcDefKey.INV_STOCK_CHECK.name())) {
            ArrayList<String> userIds = this.invCkProcessService.taskAssignee(null, customParams);
            return userIds;
        }
        return null;
    }

    public void taskCreated(String tenantId, String procDefKey, String taskKey, String businessKey, Set<String> taskAssignees) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03: \u6d41\u7a0b\u5b9a\u4e49KEY:{},\u4efb\u52a1key:{},\u4e1a\u52a1key:{},\u5904\u7406\u4eba:{}", new Object[]{procDefKey, taskKey, businessKey, taskAssignees});
    }

    public void taskCompleted(String tenantId, String procDefKey, String taskKey, String businessKey, String taskHandler) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03: \u6d41\u7a0b\u5b9a\u4e49KEY:{},\u4efb\u52a1key:{},\u4e1a\u52a1key:{}\uff0c\u4efb\u52a1\u5904\u7406\u4eba{}", new Object[]{procDefKey, taskKey, businessKey, taskHandler});
    }

    public void processStatusChange(String tenantId, String procDefKey, ProcInstStatus procInstStatus, String businessKey, CommentInfo commentInfo) {
        log.info("\u6d41\u7a0b\u56de\u8c03 procDefKey:" + procDefKey + " ,procInstStatus:" + procInstStatus + ",businessKey:" + businessKey);
        if (procDefKey.equals(ProcDefKey.INV_ADJST.name())) {
            this.invAjProcessService.processStatusChange(this.getId(businessKey), procInstStatus);
        } else if (procDefKey.equals(ProcDefKey.INV_TRN.name())) {
            this.invTrnProcessService.processStatusChange(this.getId(businessKey), procInstStatus);
        } else if (procDefKey.equals(ProcDefKey.INV_ASM.name())) {
            this.invAsmProcessService.processStatusChange(this.getId(businessKey), procInstStatus);
        } else if (procDefKey.equals(ProcDefKey.INV_STOCK_CHECK.name())) {
            this.invCkProcessService.processStatusChange(this.getId(businessKey), procInstStatus);
        }
    }

    private Long getId(String businessKey) {
        return Long.valueOf(businessKey);
    }

    private Long getTrnOuId(String businessKey, String customParams) {
        Optional<InvTrnDTO> invTrnDTO = this.invTrnService.findIdOne(this.getId(businessKey));
        Long ouId = null;
        if (invTrnDTO.isPresent()) {
            InvTrnDTO invTrnRespVO = invTrnDTO.get();
            ouId = invTrnRespVO.getOuId();
        }
        return ouId;
    }

    private Long getAsmOuId(String businessKey, String customParams) {
        Optional<InvAsmDTO> invAsmDTOOptional = this.invAsmDomainService.findIdOne(this.getId(businessKey));
        Long ouId = null;
        if (invAsmDTOOptional.isPresent()) {
            InvAsmDTO invAsmDTO = invAsmDTOOptional.get();
            ouId = invAsmDTO.getOuId();
        }
        return ouId;
    }

    private Long getAjOuId(String businessKey, String customParams) {
        Long ouId = null;
        return ouId;
    }

    private Long getIoOuId(String businessKey, String customParams) {
        Long ouId = null;
        return ouId;
    }

    public InvWorkflowCallBack(InvAjProcessService invAjProcessService, InvAjService invAjService, InvTrnProcessService invTrnProcessService, InvTrnDomainService invTrnService, InvAsmProcessService invAsmProcessService, OrgOutService orgOutService, InvCkProcessService invCkProcessService, InvAsmDomainService invAsmDomainService) {
        this.invAjProcessService = invAjProcessService;
        this.invAjService = invAjService;
        this.invTrnProcessService = invTrnProcessService;
        this.invTrnService = invTrnService;
        this.invAsmProcessService = invAsmProcessService;
        this.orgOutService = orgOutService;
        this.invCkProcessService = invCkProcessService;
        this.invAsmDomainService = invAsmDomainService;
    }
}

