/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.scene.InvSceneConfigPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.scene.InvSceneConfigQueryVO;
import com.elitesland.yst.production.inv.application.facade.vo.scene.param.InvSceneConfigQueryParam;
import com.elitesland.yst.production.inv.domain.convert.scene.InvSceneConfigConvert;
import com.elitesland.yst.production.inv.domain.entity.scene.InvSceneConfigDO;
import com.elitesland.yst.production.inv.domain.service.InvSceneConfigDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvSceneConfigDTO;
import com.elitesland.yst.production.inv.infr.repo.scene.InvSceneConfigRepo;
import com.elitesland.yst.production.inv.infr.repo.scene.InvSceneConfigRepoProc;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
public class InvSceneConfigDomainServiceImpl
implements InvSceneConfigDomainService {
    private final InvSceneConfigRepo invSceneConfigRepo;
    private final InvSceneConfigRepoProc invSceneConfigRepoProc;

    @Override
    @SysCodeProc
    public Optional<InvSceneConfigDO> findById(Long id) {
        if (StringUtils.isEmpty((Object)id)) {
            return Optional.empty();
        }
        return this.invSceneConfigRepo.findById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteById(Long id) {
        this.invSceneConfigRepo.deleteById(id);
    }

    @Override
    public void updateDynamically(InvSceneConfigDO invSceneConfigDO) {
        this.invSceneConfigRepoProc.updateDynamically(invSceneConfigDO);
    }

    @Override
    public PagingVO<InvSceneConfigPageVO> searchPage(InvSceneConfigQueryParam param) {
        return this.invSceneConfigRepoProc.searchPage(param);
    }

    @Override
    public List<InvSceneConfigQueryVO> findSceneConfiBySceneCode(String sceneCode) {
        List<InvSceneConfigDO> sceneConfigDOS = this.invSceneConfigRepo.findAllBySceneCodeIs(sceneCode);
        return sceneConfigDOS.stream().map(InvSceneConfigConvert.INSTANCE::do2VO).collect(Collectors.toList());
    }

    @Override
    public InvSceneConfigDTO findBySceneCode(String sceneCode) {
        List<InvSceneConfigDO> sceneConfigDOS = this.invSceneConfigRepo.findAllBySceneCodeIs(sceneCode);
        if (!CollectionUtils.isEmpty(sceneConfigDOS)) {
            return InvSceneConfigConvert.INSTANCE.do2DTO(sceneConfigDOS.get(0));
        }
        return null;
    }

    public InvSceneConfigDomainServiceImpl(InvSceneConfigRepo invSceneConfigRepo, InvSceneConfigRepoProc invSceneConfigRepoProc) {
        this.invSceneConfigRepo = invSceneConfigRepo;
        this.invSceneConfigRepoProc = invSceneConfigRepoProc;
    }
}

