/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.domain.service.impl;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionParam;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingRespVO;
import com.elitesland.yst.production.inv.domain.convert.InvWhAreaSettingConvert;
import com.elitesland.yst.production.inv.domain.entity.whAreaSetting.InvWhAreaSetting;
import com.elitesland.yst.production.inv.domain.entity.whAreaSetting.InvWhAreaSettingDO;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaSettingDomainService;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaSettingRpcDTO;
import com.elitesland.yst.production.inv.dto.invwhAreaSetting.InvWhAreaSettingParamRpcDTO;
import com.elitesland.yst.production.inv.infr.dto.InvWhAreaSettingDTO;
import com.elitesland.yst.production.inv.infr.repo.whAreaSetting.InvWhAreaSettingRepo;
import com.elitesland.yst.production.inv.infr.repo.whAreaSetting.InvWhAreaSettingRepoProc;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="InvWhAreaSettingDomainService")
public class InvWhAreaSettingDomainServiceImpl
implements InvWhAreaSettingDomainService {
    private final InvWhAreaSettingRepo invWhAreaSettingRepo;
    private final InvWhAreaSettingRepoProc invWhAreaSettingRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<InvWhAreaSettingDTO> search(InvWhAreaSettingParamVO param) {
        PagingVO<InvWhAreaSettingDTO> pagingVo = this.invWhAreaSettingRepoProc.search(param);
        return pagingVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveInvWhAreaSetting(InvWhAreaSetting invWhAreaSetting, Optional<InvWhAreaSettingDTO> optional) {
        if (optional.isPresent()) {
            InvWhAreaSettingDTO invWhAreaSettingDTO = optional.get();
            invWhAreaSetting.setDeter2Type(invWhAreaSettingDTO.getDeter2Type());
            invWhAreaSetting.setId(invWhAreaSettingDTO.getId());
            invWhAreaSetting.setCreator(invWhAreaSettingDTO.getCreator());
            invWhAreaSetting.setCreateUserId(invWhAreaSettingDTO.getCreateUserId());
            invWhAreaSetting.setCreateTime(invWhAreaSettingDTO.getCreateTime());
            invWhAreaSetting.setModifyTime(LocalDateTime.now());
        } else {
            invWhAreaSetting.setId(null);
            invWhAreaSetting.setCreateTime(LocalDateTime.now());
            invWhAreaSetting.setModifyTime(LocalDateTime.now());
        }
        InvWhAreaSettingDO invWhAreaSettingDO = InvWhAreaSettingConvert.INSTANCE.enToDo(invWhAreaSetting);
        Long id = ((InvWhAreaSettingDO)this.invWhAreaSettingRepo.save(invWhAreaSettingDO)).getId();
        return id;
    }

    @Override
    @SysCodeProc
    public Optional<InvWhAreaSettingDTO> findById(Long id) {
        return this.invWhAreaSettingRepo.findById(id).map(InvWhAreaSettingConvert.INSTANCE::doToDto);
    }

    @Override
    @SysCodeProc
    public Optional<InvWhAreaSettingDTO> findByDeter2(String deter2) {
        if (StringUtils.isEmpty((Object)deter2)) {
            return Optional.empty();
        }
        InvWhAreaSettingParamVO param = new InvWhAreaSettingParamVO();
        param.setDeter2(deter2);
        JPAQuery<InvWhAreaSettingDTO> jpaQuery = this.invWhAreaSettingRepoProc.select(param);
        return Optional.of((InvWhAreaSettingDTO)jpaQuery.fetchFirst());
    }

    @Override
    @SysCodeProc
    public List<InvWhAreaSettingDTO> findByIdBatch(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.EMPTY_LIST;
        }
        List<InvWhAreaSettingDTO> whAreaSettingDTOList = this.invWhAreaSettingRepo.findAllById(idList).stream().map(InvWhAreaSettingConvert.INSTANCE::doToDto).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(whAreaSettingDTOList)) {
            return Collections.EMPTY_LIST;
        }
        return whAreaSettingDTOList;
    }

    @Override
    @SysCodeProc
    public List<InvWhAreaSettingDTO> findByDeter2Batch(List<String> deter2List) {
        if (CollectionUtils.isEmpty(deter2List)) {
            return Collections.EMPTY_LIST;
        }
        InvWhAreaSettingParamVO param = new InvWhAreaSettingParamVO();
        param.setDeter2List(deter2List);
        JPAQuery<InvWhAreaSettingDTO> jpaQuery = this.invWhAreaSettingRepoProc.select(param);
        List invWhAreaSettingDTOS = jpaQuery.fetch();
        if (CollectionUtils.isEmpty((Collection)invWhAreaSettingDTOS)) {
            return Collections.EMPTY_LIST;
        }
        return invWhAreaSettingDTOS;
    }

    @Override
    @SysCodeProc
    public List<InvWhAreaSettingDTO> selectByParam(InvWhAreaSettingParamVO param) {
        JPAQuery<InvWhAreaSettingDTO> jpaQuery = this.invWhAreaSettingRepoProc.select(param);
        List invWhAreaSettingDTOS = jpaQuery.fetch();
        if (CollectionUtils.isEmpty((Collection)invWhAreaSettingDTOS)) {
            return Collections.EMPTY_LIST;
        }
        return invWhAreaSettingDTOS;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagByIds(Integer deleteFlag, List<Long> idList) {
        this.invWhAreaSettingRepoProc.updateDeleteFlagByIds(deleteFlag, idList).execute();
    }

    @Override
    public List<SelectOptionVO> listDeter2Type(SelectOptionParam param) {
        return this.invWhAreaSettingRepoProc.listDeter2Type(param);
    }

    @Override
    public List<InvWhAreaSettingRespVO> findByDeter2Types(List<String> deter2Types) {
        if (CollectionUtils.isEmpty(deter2Types)) {
            return new ArrayList<InvWhAreaSettingRespVO>();
        }
        return this.invWhAreaSettingRepoProc.findByDeter2Types(deter2Types);
    }

    @Override
    public List<InvWhAreaSettingRpcDTO> findWhAreaSettingRpcDTO(InvWhAreaSettingParamRpcDTO param) {
        return this.invWhAreaSettingRepoProc.findWhAreaSettingRpcDTO(param);
    }

    public InvWhAreaSettingDomainServiceImpl(InvWhAreaSettingRepo invWhAreaSettingRepo, InvWhAreaSettingRepoProc invWhAreaSettingRepoProc) {
        this.invWhAreaSettingRepo = invWhAreaSettingRepo;
        this.invWhAreaSettingRepoProc = invWhAreaSettingRepoProc;
    }
}

