/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.provider;

import cn.hutool.core.bean.BeanUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhSaveVO;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.PurDubbleService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaService;
import com.elitesland.yst.production.inv.application.service.InvWhService;
import com.elitesland.yst.production.inv.application.service.InvWhTreeService;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhDO;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaRpcDTO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhDeliveryRpcDTO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhDeliveryRpcDtoParam;
import com.elitesland.yst.production.inv.dto.invwh.InvWhDetailRpcDTO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhRpcDTO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.yst.production.inv.dto.invwh.InvWhSaveDTO;
import com.elitesland.yst.production.inv.provider.InvWhProvider;
import com.elitesland.yst.production.inv.util.BaseModelDTO;
import com.elitesland.yst.production.inv.utils.BeanCopyUtil;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/invWh"})
public class InvWhProviderImpl
implements InvWhProvider {
    private static final Logger log = LoggerFactory.getLogger(InvWhProviderImpl.class);
    private final InvWhDomainService invWhDomainService;
    private final OrgOutService orgOutService;
    private final SystemService systemService;
    private final InvWhAreaService invWhAreaService;
    private final InvWhService invWhService;
    private final InvWhTreeService invWhTreeService;
    private final PurDubbleService purDubbleService;

    private void translateWhRpcDTO(List<InvWhRpcDTO> invWhRpcDTOS) {
        List<Long> ouIds = invWhRpcDTOS.stream().map(InvWhRpcDTO::getOuId).distinct().collect(Collectors.toList());
        List<OrgOuRpcDTO> orgOuVOS = this.orgOutService.findOuByIds(ouIds);
        invWhRpcDTOS.forEach(VO -> {
            Optional<OrgOuRpcDTO> first1;
            List<OrgAddrAddressRpcDTO> orgAddrAddressVOS = this.findOrgAddrAddressList(VO.getAddrNo());
            if (!CollectionUtils.isEmpty(orgAddrAddressVOS)) {
                OrgAddrAddressRpcDTO orgAddrAddressVO = orgAddrAddressVOS.get(0);
                Object email = "";
                for (OrgAddrAddressRpcDTO address : orgAddrAddressVOS) {
                    email = (String)email + address.getEmail() + ";";
                }
                VO.setCountry(orgAddrAddressVO.getCountry());
                VO.setProvince(orgAddrAddressVO.getProvince());
                VO.setCity(orgAddrAddressVO.getCity());
                VO.setCounty(orgAddrAddressVO.getCounty());
                VO.setCountryName(orgAddrAddressVO.getCountry());
                VO.setProvinceName(orgAddrAddressVO.getProvinceName());
                VO.setCityName(orgAddrAddressVO.getCityName());
                VO.setCountyName(orgAddrAddressVO.getCountyName());
                VO.setDetailaddr(orgAddrAddressVO.getDetailAddr());
                VO.setEmail((String)email);
                VO.setContPerson(orgAddrAddressVO.getContPerson());
                VO.setTel(orgAddrAddressVO.getTel());
            }
            if (!CollectionUtils.isEmpty((Collection)orgOuVOS) && (first1 = orgOuVOS.stream().filter(a -> a.getId().equals(VO.getOuId())).findFirst()).isPresent()) {
                OrgOuRpcDTO orgOuVO = first1.get();
                VO.setOuName(orgOuVO.getOuName());
                VO.setOuCode(orgOuVO.getOuCode());
                VO.setOuCurr(orgOuVO.getOuCurr());
            }
        });
    }

    private List<OrgAddrAddressRpcDTO> findOrgAddrAddressList(Long addrNo) {
        OrgAddrDetailsRpcDTO orgAddrDetailsRpcDto = this.orgOutService.findRpcDtoByAddrNo(addrNo);
        if (Objects.isNull(orgAddrDetailsRpcDto)) {
            return Lists.newArrayList();
        }
        return orgAddrDetailsRpcDto.getOrgAddrAddressVos();
    }

    public ApiResult<List<InvWhDetailRpcDTO>> findWhAreaDTOByParam(InvWhRpcDtoParam param) {
        log.info("\u67e5\u8be2\u4ed3\u5e93\u53ca\u5e93\u533a\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)param);
        try {
            if (param == null) {
                throw new BusinessException("\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List<InvWhDetailRpcDTO> rpcDTOS = this.invWhDomainService.findWhRpcDTOByParam(param);
            this.translateWh(rpcDTOS);
            log.info("\u67e5\u8be2\u4ed3\u5e93\u53ca\u5e93\u533a\u7ed3\u679c\u4e3a\uff1a{}", rpcDTOS);
            return ApiResult.ok(rpcDTOS);
        }
        catch (BusinessException e) {
            log.error("findWhDTOByParam{}", (Throwable)e);
            return ApiResult.fail((String)e.getMessage());
        }
    }

    public ApiResult<List<InvWhRpcDTO>> findWhDTOByParam(InvWhRpcDtoParam param) {
        try {
            log.info("\u67e5\u8be2\u4ed3\u5e93\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)param);
            if (param == null) {
                throw new BusinessException("\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList<InvWhRpcDTO> results = new ArrayList<InvWhRpcDTO>();
            List<InvWhRpcDTO> whRpcDTOS = this.invWhDomainService.findWhPartRpcDTOByParam(param);
            Map<Long, List<InvWhRpcDTO>> map = whRpcDTOS.stream().collect(Collectors.groupingBy(BaseModelDTO::getId));
            for (Map.Entry<Long, List<InvWhRpcDTO>> wh : map.entrySet()) {
                results.add(wh.getValue().get(0));
            }
            if (!CollectionUtils.isEmpty(results)) {
                this.translateWhRpcDTO(results);
            }
            log.info("\u4ed3\u5e93\u67e5\u8be2\u7ed3\u679c\u4e3a\uff1a{}", results);
            return ApiResult.ok(results);
        }
        catch (BusinessException e) {
            log.error("findWhPartDTOByParam error:", (Throwable)e);
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @SysCodeProc
    public List<InvWhRpcDTO> findWhByDeliveryParam(InvWhDeliveryRpcDtoParam param) {
        try {
            ArrayList whDeliveryRpcDTOS;
            List<Long> whIds;
            log.info("\u6839\u636e\u914d\u9001\u8303\u56f4\u67e5\u8be2\u4ed3\u5e93\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)param);
            List<InvWhDeliveryRpcDTO> whRpcDTOByDelivery = this.invWhDomainService.findWhRpcDTOByDelivery(param);
            if (StringUtils.isNotEmpty((CharSequence)param.getPcode()) || StringUtils.isNotEmpty((CharSequence)param.getCcode()) || StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{param.getCcode()})) {
                List<InvWhDeliveryRpcDTO> byAllArea = this.invWhDomainService.findWhRpcDTOByAllArea(param);
                whRpcDTOByDelivery.addAll(byAllArea);
            }
            if (CollectionUtils.isEmpty(whIds = (whDeliveryRpcDTOS = whRpcDTOByDelivery.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<InvWhDeliveryRpcDTO>(Comparator.comparing(f -> f.getWhId()))), ArrayList::new))).stream().map(InvWhDeliveryRpcDTO::getWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                ArrayList<InvWhRpcDTO> whPartRpcDTOS = new ArrayList<InvWhRpcDTO>();
                return whPartRpcDTOS;
            }
            List<InvWhAreaRpcDTO> invWhAreaRpcDTOS = this.invWhAreaService.findWhAreaRpcDTOByWhIds(whIds);
            List<InvWhRpcDTO> invWhRpcDTOS = whDeliveryRpcDTOS.stream().map(v -> {
                InvWhRpcDTO invWhRpcDTO = new InvWhRpcDTO();
                invWhRpcDTO.setId(v.getWhId());
                if (!CollectionUtils.isEmpty((Collection)invWhAreaRpcDTOS)) {
                    List whAreaRpcDTOS = invWhAreaRpcDTOS.stream().filter(i -> i.getWhId().equals(v.getWhId())).collect(Collectors.toList());
                    invWhRpcDTO.setInvWhAreaRespVOList(whAreaRpcDTOS);
                }
                invWhRpcDTO.setWhType(v.getWhType());
                invWhRpcDTO.setWhCode(v.getWhCode());
                invWhRpcDTO.setWhName(v.getWhName());
                invWhRpcDTO.setAddrNo(v.getAddrNo());
                invWhRpcDTO.setOuId(v.getOuId());
                invWhRpcDTO.setThirdplFlag(v.getThirdplFlag());
                invWhRpcDTO.setErpCode(v.getErpCode());
                invWhRpcDTO.setEs1(v.getEs1());
                return invWhRpcDTO;
            }).collect(Collectors.toList());
            this.translate2(invWhRpcDTOS);
            log.info("\u6839\u636e\u914d\u9001\u8303\u56f4\u67e5\u8be2\u4ed3\u5e93\u7ed3\u679c\uff1a{}", invWhRpcDTOS);
            return invWhRpcDTOS;
        }
        catch (BusinessException e) {
            log.error("findWhDeliveryDTOByParam", (Throwable)e);
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
    }

    public ApiResult<String> createTreeOne(InvWhSaveDTO param) {
        InvWhSaveVO invWhSaveVO = (InvWhSaveVO)BeanUtil.copyProperties((Object)param, InvWhSaveVO.class, (String[])new String[0]);
        Long treeOne = this.invWhTreeService.createTreeOne(invWhSaveVO);
        if (StringUtils.isNotEmpty((CharSequence)treeOne.toString())) {
            return ApiResult.ok((Object)treeOne.toString());
        }
        return ApiResult.fail();
    }

    private Boolean existVerify(Long id, String whCode) {
        InvWhParamVO param = new InvWhParamVO();
        param.setWhCode(whCode);
        List<InvWhRespVO> invWhRespVOList = this.invWhDomainService.select(param);
        return invWhRespVOList.stream().anyMatch(w -> !w.getId().equals(id));
    }

    private void translate2(List<InvWhRpcDTO> invWhPartRpcDtoVOList) {
        List<Long> ouIds = invWhPartRpcDtoVOList.stream().map(InvWhRpcDTO::getOuId).distinct().collect(Collectors.toList());
        List<OrgOuRpcDTO> orgOuVOS = this.orgOutService.findOuByIds(ouIds);
        invWhPartRpcDtoVOList.forEach(VO -> {
            Optional<OrgOuRpcDTO> first1 = orgOuVOS.stream().filter(a -> a.getId().equals(VO.getOuId())).findFirst();
            if (first1.isPresent()) {
                OrgOuRpcDTO orgOuVO = first1.get();
                VO.setOuName(orgOuVO.getOuName());
                VO.setOuCode(orgOuVO.getOuCode());
                VO.setOuCurr(orgOuVO.getOuCurr());
            }
        });
    }

    private void translateWh(List<InvWhDetailRpcDTO> invWhDetailRpcDTOList) {
        List<Long> ouIds = invWhDetailRpcDTOList.stream().map(InvWhDetailRpcDTO::getOuId).distinct().collect(Collectors.toList());
        List<OrgOuRpcDTO> orgOuVOS = this.orgOutService.findOuByIds(ouIds);
        invWhDetailRpcDTOList.forEach(VO -> {
            Optional<OrgOuRpcDTO> first1;
            List<OrgAddrAddressRpcDTO> orgAddrAddressVOS = this.findOrgAddrAddressList(VO.getAddrNo());
            if (!CollectionUtils.isEmpty(orgAddrAddressVOS)) {
                OrgAddrAddressRpcDTO orgAddrAddressVO = orgAddrAddressVOS.get(0);
                Object email = "";
                for (OrgAddrAddressRpcDTO address : orgAddrAddressVOS) {
                    email = (String)email + address.getEmail() + ";";
                }
                VO.setCountry(orgAddrAddressVO.getCountry());
                VO.setProvince(orgAddrAddressVO.getProvince());
                VO.setCity(orgAddrAddressVO.getCity());
                VO.setCounty(orgAddrAddressVO.getCounty());
                VO.setCountryName(orgAddrAddressVO.getCountry());
                VO.setProvinceName(orgAddrAddressVO.getProvinceName());
                VO.setCityName(orgAddrAddressVO.getCityName());
                VO.setCountyName(orgAddrAddressVO.getCountyName());
                VO.setDetailaddr(orgAddrAddressVO.getDetailAddr());
                VO.setEmail((String)email);
                VO.setContPerson(orgAddrAddressVO.getContPerson());
                VO.setTel(orgAddrAddressVO.getTel());
            }
            if (!CollectionUtils.isEmpty((Collection)orgOuVOS) && (first1 = orgOuVOS.stream().filter(a -> a.getId().equals(VO.getOuId())).findFirst()).isPresent()) {
                OrgOuRpcDTO orgOuVO = first1.get();
                VO.setOuName(orgOuVO.getOuName());
                VO.setOuCode(orgOuVO.getOuCode());
                VO.setOuCurr(orgOuVO.getOuCurr());
            }
        });
    }

    public void update(InvWhDO invWhDO) {
        Optional<InvWhDO> optional = this.invWhDomainService.findById(invWhDO.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + invWhDO.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(invWhDO, optional.get(), BeanCopyUtil.getNullAndIgnorePropertyNames(invWhDO, new String[0]));
        this.invWhDomainService.saveInvWh(invWhDO);
    }

    private void translateWhArea(List<InvWhAreaRespVO> invWhAreaRespVOS, List<InvWhRespVO> invWhRespVOList) {
        List custIds = invWhAreaRespVOS.stream().filter(VO -> VO.getPType() != null && VO.getPCode() != null && VO.getPType().equals(UdcEnum.INV_PARTNER_TYPE_CUST.getValueCode())).map(InvWhAreaRespVO::getEs1).distinct().map(Long::valueOf).collect(Collectors.toList());
        List<Long> suppIds = invWhAreaRespVOS.stream().filter(VO -> VO.getPType() != null && VO.getPCode() != null && VO.getPType().equals(UdcEnum.INV_PARTNER_TYPE_SUPP.getValueCode())).map(InvWhAreaRespVO::getEs1).distinct().map(Long::valueOf).collect(Collectors.toList());
        List empIds = invWhAreaRespVOS.stream().filter(VO -> VO.getPType() != null && VO.getPCode() != null && VO.getPType().equals(UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode())).map(InvWhAreaRespVO::getEs1).distinct().map(Long::valueOf).collect(Collectors.toList());
        List<PurSuppBaseRpcDTO> suppRespVOS = this.purDubbleService.findSuppByIdBatch(suppIds);
        OrgEmpRpcDtoParam empParam = new OrgEmpRpcDtoParam();
        empParam.setEmpIds(empIds);
        List<OrgEmpRpcDTO> empVOS = this.orgOutService.findEmpDtoByParam(empParam);
        invWhAreaRespVOS.forEach(VO -> {
            invWhRespVOList.stream().filter(record -> VO.getWhId().equals(record.getId())).findAny().ifPresent(VO::setInvWhRespVO);
            if (VO.getPType() != null && VO.getPCode() != null && !UdcEnum.INV_PARTNER_TYPE_CUST.getValueCode().equals(VO.getPType())) {
                if (UdcEnum.INV_PARTNER_TYPE_SUPP.getValueCode().equals(VO.getPType())) {
                    Optional<PurSuppBaseRpcDTO> first = suppRespVOS.stream().filter(a -> a.getId().toString().equals(VO.getEs1())).findFirst();
                    first.ifPresent(suppRespVO -> VO.setPName(suppRespVO.getSuppName()));
                } else {
                    Optional<OrgEmpRpcDTO> first = empVOS.stream().filter(a -> a.getId().toString().equals(VO.getEs1())).findFirst();
                    first.ifPresent(empVO -> VO.setPName(empVO.getEmpName()));
                }
            }
        });
    }

    public InvWhProviderImpl(InvWhDomainService invWhDomainService, OrgOutService orgOutService, SystemService systemService, InvWhAreaService invWhAreaService, InvWhService invWhService, InvWhTreeService invWhTreeService, PurDubbleService purDubbleService) {
        this.invWhDomainService = invWhDomainService;
        this.orgOutService = orgOutService;
        this.systemService = systemService;
        this.invWhAreaService = invWhAreaService;
        this.invWhService = invWhService;
        this.invWhTreeService = invWhTreeService;
        this.purDubbleService = purDubbleService;
    }
}

