/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.utils;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.builder.ExcelWriterTableBuilder;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.handler.RowWriteHandler;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.merge.AbstractMergeStrategy;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitesland.yst.production.inv.utils.CustomWriteCellValue;
import com.elitesland.yst.production.inv.utils.RptCustomWriterStyle;
import com.elitesland.yst.production.inv.utils.excel.LocalDateTimeConverter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ObjectUtils;

public class ExcelWriteUtil {
    private static final Integer GROUP_SIZE = 10000;

    public OutputStream getOutputStream(HttpServletResponse response, String filename) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        response.reset();
        filename = URLEncoder.encode(filename, StandardCharsets.UTF_8);
        response.setHeader("Content-disposition", "attachment; filename=" + filename + ".xlsx");
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/x-download");
        return outputStream;
    }

    public ExcelWriter createExcelWriter(OutputStream outputStream, String classpath, CellWriteHandler customWriteCellStype, AbstractMergeStrategy customWriteCellMerge, RowWriteHandler rowWriteHandler) throws IOException {
        InputStream inputStream = new ClassPathResource(classpath).getInputStream();
        ExcelWriter excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)outputStream).registerWriteHandler((WriteHandler)customWriteCellStype)).registerWriteHandler((WriteHandler)customWriteCellMerge)).registerWriteHandler((WriteHandler)rowWriteHandler)).withTemplate(inputStream).build();
        return excelWriter;
    }

    public WriteSheet createWriteSheet() {
        return EasyExcel.writerSheet().build();
    }

    public void fillList(ExcelWriter excelWriter, WriteSheet writeSheet, List<List<?>> datas) {
        FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
        for (List<?> data : datas) {
            excelWriter.fill(data, fillConfig, writeSheet);
        }
    }

    public void fillMap(ExcelWriter excelWriter, WriteSheet writeSheet, Map data) {
        excelWriter.fill((Object)data, writeSheet);
    }

    public void closeExcelWriter(HttpServletResponse response, ExcelWriter excelWriter, OutputStream outputStream) throws IOException {
        if (!ObjectUtils.isEmpty((Object)excelWriter)) {
            excelWriter.finish();
        }
        if (!ObjectUtils.isEmpty((Object)outputStream)) {
            outputStream.flush();
        }
        if (!ObjectUtils.isEmpty((Object)response)) {
            response.getOutputStream().close();
        }
    }

    public static void excelWrite(HttpServletResponse response, List<?> list, Class<?> clazz, String fileName, String sheetName) throws IOException {
        response.setContentType("application/octet-stream");
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8);
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        ExcelWriterBuilder write = EasyExcel.write((OutputStream)response.getOutputStream(), clazz);
        ((ExcelWriterBuilder)write.registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(Integer.valueOf(0), sheetName).doWrite(list);
    }

    public static void excelWrite1(HttpServletResponse response, List<?> list, Class<?> clazz, String fileName, String sheetName) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8);
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), clazz).registerConverter((Converter)new LocalDateTimeConverter())).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName + "1").doWrite(list);
    }

    public static void excelWriteDynamic(HttpServletResponse response, List<?> list, List<?> list1, Class<?> clazz, String fileName, String sheetName) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8);
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), clazz).head(list1)).registerConverter((Converter)new LocalDateTimeConverter())).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName + "1").doWrite(list);
    }

    public static void excelWriteDuoHeader(HttpServletResponse response, List<?> dataA, List<?> dataB, Class<?> typeA, Class<?> typeB, String fileName, String sheetName) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8);
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ExcelWriter writer = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream()).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();
        WriteSheet writeSheet = EasyExcel.writerSheet((String)sheetName).build();
        WriteTable writeTableA = ((ExcelWriterTableBuilder)EasyExcel.writerTable((Integer)0).head(typeA)).build();
        WriteTable writeTableB = ((ExcelWriterTableBuilder)EasyExcel.writerTable((Integer)1).head(typeB)).build();
        writer.write(dataA, writeSheet, writeTableA);
        writer.write(dataB, writeSheet, writeTableB);
        writer.finish();
    }

    public static void excelWriteRpt(HttpServletResponse response, List<?> list, Class<?> clazz, String fileName, String sheetName) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8);
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        headWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.PALE_BLUE.getIndex()));
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setColor(Short.valueOf(IndexedColors.BLACK.getIndex()));
        headWriteFont.setFontHeightInPoints(Short.valueOf((short)10));
        headWriteFont.setBold(Boolean.valueOf(true));
        headWriteFont.setFontName("Arial");
        headWriteCellStyle.setWriteFont(headWriteFont);
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        WriteFont contentWriteFont = new WriteFont();
        contentWriteFont.setFontHeightInPoints(Short.valueOf((short)10));
        contentWriteFont.setFontName("Arial");
        contentWriteFont.setBold(Boolean.valueOf(false));
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
        ExcelWriterBuilder write = EasyExcel.write((OutputStream)response.getOutputStream(), clazz);
        ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)write.registerConverter((Converter)new LocalDateTimeConverter())).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).registerWriteHandler((WriteHandler)horizontalCellStyleStrategy)).registerWriteHandler((WriteHandler)new RptCustomWriterStyle())).registerWriteHandler((WriteHandler)new CustomWriteCellValue())).sheet(sheetName + "1").doWrite(list);
    }

    public static void excelWriteGroup(HttpServletResponse response, List<?> list, Class<?> clazz, String fileName, String sheetName) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8);
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ExcelWriter excelWriter = EasyExcel.write((OutputStream)response.getOutputStream()).build();
        List lists = Lists.partition(list, (int)GROUP_SIZE);
        for (int i = 0; i < lists.size(); ++i) {
            WriteSheet writeSheet1 = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)i, (String)(sheetName + (i + 1))).head(clazz)).build();
            excelWriter.write((List)lists.get(i), writeSheet1);
        }
        excelWriter.finish();
    }
}

