package com.elitesland.yst.production.inv.application.facade.vo;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * INV_AJ
 * InvAjDVO
 * 库存调整
 *
 * @author lich.chen
 * @date 2020/08/3
 */
@Data
@ApiModel("库存调整")
public class InvAjAndInvAjDRespVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 1096288064972391708L;
    @ApiModelProperty("明细Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long did;

    @ApiModelProperty("头Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    private String apprStatus;

    @ApiModelProperty("审批时间")
    private LocalDateTime apprTime;

    @ApiModelProperty("审批人ID")
    private Long apprUserId;

    @ApiModelProperty("审批人名称")
    private String apprUserName;

    @ApiModelProperty("审批人")
    private Long apprUser;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("流程实例id")
    private String apprProcInstId;

    @ApiModelProperty("关联单据号 外部单据号")
    private String relateNo;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("交易日期")
    private LocalDateTime ioDate;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("调整类型 [UDC]INV:AJ_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("调整单状态 [UDC]INV:AJ_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    private String reasonCode;
    private String reasonCodeName;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;
    private String deter1Name;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;
    private String deter2Name;

    @ApiModelProperty("客户标识")
    private String deter3;

    @ApiModelProperty("批次")
    private String lotNo;

    @ApiModelProperty("是否默认启用批次")
    private Boolean lotFlag;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("调整数量")
    private BigDecimal qty;

    @ApiModelProperty("单位")
    private String uom;
    @ApiModelProperty("单位名称")
    private String uomName;


    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("销毁日期")
    private LocalDateTime destroyDate;

    @ApiModelProperty("销毁员工")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long destroyEmpId;

    @ApiModelProperty("申请日期")
    private LocalDateTime applyDate;

    @ApiModelProperty("关联单据编号")
    private String relateDocNo;

    @ApiModelProperty("承运商")
    private String carrier;

    @ApiModelProperty("仓库名")
    private String whName;

    @ApiModelProperty("仓库代码")
    private String whCode;

    @ApiModelProperty("实物是否销毁")
    private Boolean destroyFlag;

    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    @ApiModelProperty("实物是否销毁")
    private LocalDateTime expireDate;

    @ApiModelProperty("单位成本")
    private BigDecimal costPrice;

    @ApiModelProperty("成本金额")
    private BigDecimal costAmt;

    @ApiModelProperty("外部单据编号")
    private String outerNo;

    @ApiModelProperty("外部单据行号")
    private String outerLineno;

    @ApiModelProperty("外部单据公司")
    private String outerOu;

    @ApiModelProperty("外部单据类型")
    private String outerType;

    @ApiModelProperty("合作伙伴类型")
    private String pType;

    @ApiModelProperty("合作伙伴类型名称")
    private String pTypeName;

    @ApiModelProperty("合作伙伴名称")
    private String pName;

    @ApiModelProperty("合作伙伴编码")
    private String pCode;

    @ApiModelProperty("部门ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("部门")
    private String buName;

    @ApiModelProperty("领域编码")
    private String region;

    /**
     */
    @ApiModelProperty("单据来源标示：1为外部过来单据")
    private Integer sourceFlag;

    @ApiModelProperty("调整金额")
    BigDecimal ajAmt;
    @ApiModelProperty("单据类别")
    private String docCls;
    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;
    public String getProcInstStatusName() {
        return procInstStatus != null ? procInstStatus.getDesc() : null;
    }

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("限定字段1")
    private String limit1;

    @ApiModelProperty("限定字段2")
    private String limit2;

    @ApiModelProperty("限定字段3")
    private String limit3;
}
