package com.elitesland.yst.production.inv.application.facade.vo;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.time.LocalDateTime;
import java.util.List;


@Data
@ApiModel(value = "inv_aj_d", description = "库存调整")
public class InvAjDQueryAllParamVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 3921684085719051634L;

    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long masId;

    @ApiModelProperty("主表IDs")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> masIds;

    @ApiModelProperty("是否已销毁")
    Boolean destroyFlag;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    List<String> deter2;

    @ApiModelProperty("客户标识")
    String deter3;

    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    String apprStatus;

    @ApiModelProperty("合作伙伴编码")
    String pCode;

    @ApiModelProperty("创建日期")
    List<LocalDateTime> createTime;

    @ApiModelProperty("商品名称")
    String deter4;

    @ApiModelProperty("批次")
    String lotNo;

    @ApiModelProperty("调整类型 [UDC]INV:AJ_TYPE")
    String docType;

    @ApiModelProperty("单据编号")
    String docNo;

    @ApiModelProperty("关联单据号 外部单据号")
    String relateNo;

    @ApiModelProperty("关联单据编号（RMA）")
    String relateDocNo;

    @ApiModelProperty("调整单状态 [UDC]INV:AJ_STATUS")
    @SysCode(sys = "yst-inv", mod = "AJ_STATUS")
    String docStatus;
    String docStatusName;

    @ApiModelProperty("品项编号")
    String itemCode;

    @ApiModelProperty("品项名称")
    String itemName;

    @ApiModelProperty("品牌")
    List<String> brands;

    @ApiModelProperty("商品")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> itemIds;

    @ApiModelProperty("交易日期 实际出入库日期")
    List<LocalDateTime> ioDates;

    @ApiModelProperty("申请日期")
    List<LocalDateTime> applyDates;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> whIds;

    @ApiModelProperty("外部单据编号")
    String outerNo;

    @ApiModelProperty("公司ID")
    List<Long> ouIds;

    @ApiModelProperty("原因码")
    String reasonCode;

    @ApiModelProperty("申请人id")
    List<Long> applyEmpIds;

    /**
     */
    @ApiModelProperty("单据来源标示：1为外部过来单据")
    private Integer sourceFlag;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("创建时间-起")
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    private LocalDateTime createTimeStart;

    @ApiModelProperty("创建时间-止")
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    private LocalDateTime createTimeEnd;

    @ApiModelProperty("申请日期-起")
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    private LocalDateTime applyDateStart;

    @ApiModelProperty("申请日期-止")
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    private LocalDateTime applyDateEnd;

    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("功能区关键字查询")
    private String deter2KeyWord;

}

