package com.elitesland.yst.production.inv.application.facade.vo.invstk;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 在库商品查询条件实体
 * </p >
 *
 * @author jeesie.jiang
 * @date 2021/6/28
 */
@Data
public class InvStkItemQueryParam extends AbstractOrderQueryParam implements Serializable{

    private static final long serialVersionUID = -3284318810676315265L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品ID")
    private Long itemId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品ID集合")
    private List<Long> itemIds;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("品项编号/名称，支持模糊查询")
    private String itemCodeName;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("功能库区[UDC]INV:FUNC_TYPE")
    private String deter2;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("仓库ID")
    private Long whId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("仓库ID")
    private List<Long> whIds;

    @ApiModelProperty("商品属性")
    private Boolean lotFlag;

    @ApiModelProperty("商品单位")
    private String uom;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司ID集合")
    private List<Long> ouIds;

    @ApiModelProperty("发运基地ID集合")
    private List<Long> desIds;





}
