package com.elitesland.yst.production.inv.application.facade.vo.invstk;


import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.wildfly.common.annotation.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
public class InvStkItemUomParam implements Serializable {

    private static final long serialVersionUID = 7532971054749143549L;
    @ApiModelProperty("商品ID")
    @NotNull
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("单位")
    @NotBlank(message = "存在没有转换单位【toUom】的商品，请检查")
    private String toUom;
}
