package com.elitesland.yst.production.inv.application.facade.vo.invwh;

/**
 * 库区(OrgWhArea)实体类
 *
 * @author zhao_qiao_gong
 * @since 2020-07-16 14:07:34
 */

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author zhao_qiao_gong
 * @since 2020-07-16 14:07:34
 */
@Data
@ApiModel(value = "inv_wh_area", description = "库区")
public class InvWhAreaParamVO extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = 8823361025797091146L;

    @ApiModelProperty("仓库编号")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("仓库Ids")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> whIds;

    @ApiModelProperty("公司Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("仓库状态")
    private String whStatus;

    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("仓库类型")
    private String whType;

    @ApiModelProperty("仓库类型")
    private String whType2;

    @ApiModelProperty("库存合作伙伴编码")
    private String pCode;

    @ApiModelProperty("库存合作伙伴编码集合")
    private List<String> pCodes;

    @ApiModelProperty("库存合作伙伴类型")
    private String pType;

    @ApiModelProperty("库存合作伙伴类型")
    private String pptype;

    @ApiModelProperty("库存合作伙伴名称")
    private String pName;

    @ApiModelProperty("ERP编号")
    private String outerCode;

    @ApiModelProperty("多字段查询关键字")
    String multiKeywords;

    @ApiModelProperty("功能库区关键词")
    String deterType;

    @ApiModelProperty("功能区")
    private List<String> deter2s;

    @ApiModelProperty("仓库类型")
    private List<String> whTypes;

    @ApiModelProperty("营业厅编码")
    private String businessCode;

    @ApiModelProperty("记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("记录最后更新者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 版本信息，前端不用传
     */
    @ApiModelProperty("版本信息，前端不用传")
    private Integer auditDataVersion;

    @ApiModelProperty("标识位筛选-前端专用")
    private Boolean isFliter;

    @ApiModelProperty("外部系统仓库编码")
    private String otherWhCode;

    @ApiModelProperty("外部仓库类型")
    private String otherWhType;
    @ApiModelProperty("所属组织")
    private String belongBuId;

    @ApiModelProperty("仓库模糊查询")
    private String keyWord;

    @ApiModelProperty("功能区关键字查询")
    private String deter2KeyWord;

    @ApiModelProperty("发运地id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long desId;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    @ApiModelProperty("销售组织编码")
    private String desCode;
    @ApiModelProperty("销售组织编码集合")
    private List<String> desCodeList;

}
