package com.elitesland.yst.production.inv.application.facade.vo.invwh;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 库区(OrgWhArea)实体类
 *
 * @author zhao_qiao_gong
 * @since 2020-07-16 14:07:33
 */

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author zhao_qiao_gong
 * @since 2020-07-16 14:07:33
 */
@Data
@ApiModel(value = "inv_wh_area", description = "库区")
public class InvWhAreaRespVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 127735094945711342L;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("地址号 仓库本身的地址号")
    private Long addrNo;

    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("权限id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secBuId;

    @ApiModelProperty("数据归属账号id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secUserId;

    @ApiModelProperty("数据归属公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secOuId;

    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    private String whArea;

    private String whAreaName;

    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv",mod = "TEMP_TYPE")
    private String deter1;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1Name;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区编号")
    private String deter2;

    @ApiModelProperty("功能区名")
    private String deter2Name;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    @ApiModelProperty("功能区类型名")
    private String deter2TypeName;

    @ApiModelProperty("功能区类型ID")
    private Long deter2TypeId;

    @ApiModelProperty("功能区状态")
    private Integer deter2Status;

    /**
     * 客户地址号 ADDR_NO
     */
    @ApiModelProperty("客户id")
    private String deter3;
    /**
     * 限定词4
     */
    @ApiModelProperty("限定词4")
    private String deter4;

    /**
     * 限定词5
     */
    @ApiModelProperty("限定词5")
    private String deter5;
    /**
     * 限定词6
     */
    @ApiModelProperty("限定词6")
    private String deter6;
    /**
     * 限定词7
     */
    @ApiModelProperty("限定词7")
    private String deter7;
    /**
     * 限定词8
     */
    @ApiModelProperty("限定词8")
    private String deter8;

    /**
     * ERP编号
     */
    @ApiModelProperty("ERP编号")
    private String outerCode;

    @ApiModelProperty("ERP名称")
    private String outerCodeName;
    /**
     * E1库区编号
     */
    @ApiModelProperty("E1库区编号")
    private String outerCode2;
    private String outerCode2Name;
    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;
    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;
    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;


    @ApiModelProperty("仓库")
    private InvWhRespVO invWhRespVO;

    /**
     * 库存合作伙伴编码
     */
    @ApiModelProperty("合作伙伴编码")
    private String pCode;

    /**
     * 库存合作伙伴名称
     */
    @ApiModelProperty("合作伙伴名称")
    private String pName;

    /**
     * 合作伙伴地址
     */
    @ApiModelProperty("合作伙伴地址")
    private String pAddr;

    /**
     * 合作伙伴类型
     */
    @ApiModelProperty("合作伙伴类型")
    @SysCode(sys="INV",mod = "PARTNER_TYPE")
    private String pType;

    /**
     * 合作伙伴类型
     */
    @ApiModelProperty("合作伙伴类型名称")
    private String pTypeName;

    @ApiModelProperty("业务人员可选，默认为：是")
    private Boolean businessChoose;

    @ApiModelProperty("创建人名")
    private String createUserName;

    @ApiModelProperty("京东事业部编码")
    private String jdsybCode;

    @ApiModelProperty("京东事业部编码")
    private String jdsybCodeName;

    @ApiModelProperty("详细地址")
    private String detailaddr;

    @ApiModelProperty("外部系统编码")
    private String otherSysCode;

    @ApiModelProperty("外部系统名称")
    private String otherSysName;
    @ApiModelProperty("所属组织类型")
    private String belongBuType;

    @ApiModelProperty("所属组织")
    private String belongBuId;
    @ApiModelProperty("所属组织名称")
    private String belongBuName;
    @ApiModelProperty("所属组织编码")
    private String belongBuCode;

    @ApiModelProperty("国家")
    @SysCode(sys = "COM", mod = "COUNTRY")
    private String country;
    private String countryName;
    @ApiModelProperty("省")
    private String province;
    private String provinceName;
    @ApiModelProperty("市")
    private String city;
    private String cityName;
    @ApiModelProperty("区县")
    private String county;
    private String countyName;

    @ApiModelProperty("发运基地id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long desId;

    @ApiModelProperty("发运基地编码")
    private String desCode;
    @ApiModelProperty("销售组织名称")
    private String desCodeName;
    @ApiModelProperty("销售组织编码集合")
    private List<String> desCodeList;

    @ApiModelProperty("发运基地名")
    private String desName;
}
