package com.elitesland.yst.production.inv.application.facade.vo.lot;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 批次库存自动分配（公共方法25出参）
 * </p>
 *
 * @author ssy
 * @since 2020-07-29 09:39:25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "批次库存自动分配（公共方法25出参）", description = "批次库存自动分配（公共方法25出参）")
public class InvLotCommon25OutRespVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 4879423629479243046L;

//    a.功能区,批次号,订单数量,分配数量,生产日期,失效日期,批次效期天数,客户最低允收期天数,对应的卫检单号；
//    b.是否超允收期：通过客户最低允收期天数与批次效期天数对比，如果小于等于则“否”，如果大于则“是”；
//    c.卫检单附件；页面上如果需要下载，则通过批次号查询卫检单并下载；
//    d.最近出货批次：通过订单明细表依据“客户+商品+创建时间”，查询最新的批次信息

    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;

    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("入库日期")
    private LocalDateTime inDate;

    @ApiModelProperty("温层[UDC]INV:TEMP_TYPE")
    private String deter1;

    @ApiModelProperty("功能库区[UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("客户标识")
    private String deter3;

//    @ApiModelProperty("单位")
//    private String uom;
//
//    @ApiModelProperty("单位2")
//    private String uom2;
//
//    @ApiModelProperty("单位转换率")
//    private Double uomRatio;
//
//    @ApiModelProperty("单位转换率2")
//    private Double uomRatio2;

    @ApiModelProperty("要求数量")
    private BigDecimal demandQty;

//    @ApiModelProperty("现有量")
//    private Double ohQty;
//
//    @ApiModelProperty("")
//    private Double opQty;
//
//    @ApiModelProperty("锁定量 因各种原因锁定的量，如低于成本时防止过量销售，或是调拨中，或是做为活动预留，或是因不良、损坏")
//    private Double lockQty;
//
//    @ApiModelProperty("在途量")
//    private Double owQty;
//
//    @ApiModelProperty("可用量 根据本行适用策略计算的速取数，策略如现有量-预留量-锁定量+在途量=可用量")
//    private Double avalQty;
//
//    @ApiModelProperty("体积")
//    private Double volume;
//
//    @ApiModelProperty("净重")
//    private Double netWeight;
//
//    @ApiModelProperty("毛重")
//    private Double grossWeight;
//
//    @ApiModelProperty("重量")
//    private Double weight;
//
//    @ApiModelProperty("重量单位")
//    private String weightUomCode;
//
//    @ApiModelProperty("重量转换率 重量单位与主单位")
//    private Double weightRatio;
//
//    @ApiModelProperty("库存描述")
//    private String stkDesc;

    /**
     * 来源单据类别
     */
    @ApiModelProperty("来源单据类别")
    private String srcDocCls;
    /**
     * 来源单据ID
     */
    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;
    /**
     * 来源单据编号
     */
    @ApiModelProperty("来源单据编号")
    private String srcDocNo;
    /**
     * 来源单据明细ID
     */
    @ApiModelProperty("来源单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocDid;


    @ApiModelProperty("每个批次需要分配的数量")
    private BigDecimal allocQty;

    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    @ApiModelProperty("失效日期")
    private LocalDateTime expireDate;

    @ApiModelProperty("剩余效期天数 每天自动计算")
    private Integer untilExpireDays;
//
//    @ApiModelProperty("新鲜度要求(最低允收期天数))")
//    private Double fressTypeDays;

    @ApiModelProperty("默认卫检单编号")
    private String sinNo;

    @ApiModelProperty("单据类型【RO：预留单、STK：库存】")
    private String orderType;

}
