package com.elitesland.yst.production.inv.application.facade.vo.lot;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.sun.istack.NotNull;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 批次库存手工分配（公共方法27入参）
 * </p>
 *
 * @author ssy
 * @since 2020-08-20
 */
@Data
@ToString(callSuper=true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "批次库存手工分配（公共方法27入参）", description = "批次库存手工分配（公共方法27入参）")
public class InvLotCommon27InSaveVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 7984552100264186929L;

    @NotNull
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("客户ID")
    private Long custId;

    @NotNull
    @ApiModelProperty("数量")
    private BigDecimal adjustQty;

    @NotEmpty
    @ApiModelProperty("分配单据号")
    private String allocOrderNo;

    @ApiModelProperty("预留单号")
    private String roNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("预留单id")
    private Long roId;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("预留单明细id")
    private Long roDid;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("库存id")
    private Long invStkId;

    @NotEmpty
    @ApiModelProperty("行号")
    private Double lineNo;

    @NotNull
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("销售订单明细ID")
    private Long salSoDId;

    @NotNull
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("销售订单ID")
    private Long salSoId;

    @NotEmpty
    @ApiModelProperty("销售订单来源")
    private String srcDocCls;

    @NotEmpty
    @ApiModelProperty("销售订单编号")
    private String soDocNo;

}
