package com.elitesland.yst.production.inv.application.facade.vo.scene;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Tom.su
 * @program yst-inv
 * @description
 * @date 2022/04/20 18:12
 */
@Data
@ApiModel("分页传输类")
public class InvSceneConfigPageVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 4212038342420493568L;

    @ApiModelProperty("库存场景码")
    private String sceneCode;

    @ApiModelProperty("库存场景描述，限定长度60中文字符之内")
    private String sceneDesc;

    @ApiModelProperty("触发单据类型")
    @SysCode(sys = "yst-supp",mod = "DOC_CLS")
    private String optDocType;

    @ApiModelProperty("触发单据类型")
    private String optDocTypeName;

    @ApiModelProperty("触发单据操作描述")
    private String optDocDesc;

    @ApiModelProperty("启用状态  Y-是 N-否")
    private String isEnable;

    @ApiModelProperty(value = "主表ID")
    private Long masId;

    @ApiModelProperty(value = "操作码")
    private String ioCode;

    @ApiModelProperty(value = "操作码名称")
    private String ioName;

    @ApiModelProperty(value = "操作类型")
    private String ioType;

    @ApiModelProperty(value = "操作类型名称")
    private String ioTypeName;

    @ApiModelProperty(value = "操作描述,限长200位")
    private String optDesc;

    @ApiModelProperty(value = "执行序列")
    private Integer optSeq;

    @ApiModelProperty(value = "关联单据是否必传 Y-是 N-否")
    private String isRelDocReq;

    @ApiModelProperty(value = "是否使用关联单据操作库存 Y-是 N-否")
    private String isUseRelDoc;

    @ApiModelProperty(value = "关联单据类型")
    @SysCode(sys = "COM",mod = "DOC_CLS")
    private String relDocType;

    @ApiModelProperty(value = "关联单据类型名称")
    private String relDocTypeName;

    @ApiModelProperty(value = "指定功能区编码")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;

    @ApiModelProperty(value = "指定功能区编码名称")
    private String deter2Name;

    @ApiModelProperty(value = "库存操作体")
    @SysCode(sys = "yst-inv",mod = "OPT_TYPE")
    private String whoptType;
    private String whoptTypeName;


}