package com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:功能区配置
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/19
 * @Version 1.0
 * @Content:
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class InvWhAreaSettingRespVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 5351319281526278536L;

    @ApiModelProperty("功能区编码")
    private String deter2;
    @ApiModelProperty("功能区名称")
    private String deter2Name;

    @ApiModelProperty("合作伙伴类型 [UDC]INV:PARTNER_TYPE")
    @SysCode(sys = "yst-inv", mod = "PARTNER_TYPE")
    private String pType;
    @ApiModelProperty("合作伙伴类型名称")
    private String pTypeName;
    @ApiModelProperty("可使用仓库类型编码、可多选、逗号分隔存储")
    private String whType;
    @ApiModelProperty("可使用仓库类型编码、可多选、逗号分隔存储")
    private List<String> whTypes;
    @ApiModelProperty("可使用仓库类型编码名称")
    private String whTypeName;
    @ApiModelProperty("建仓前端是否可选 [UDC]INV:BUSINESS_CHOOSE")
    private Boolean businessChoose;
    @ApiModelProperty("建仓前端是否可选名称")
    private String businessChooseName;
    @ApiModelProperty("是否零价库 [UDC]INV:ZERO_WH")
    private Boolean isZeroWh;
    @ApiModelProperty("是否零价库名称")
    private String isZeroWhName;

    @ApiModelProperty("是否启用，默认为启用 [UDC]INV:ACTIVE_STATUS")
    @SysCode(sys = "yst-inv", mod = "ACTIVE_STATUS")
    private String status;
    @ApiModelProperty("是否启用名称")
    private String statusName;

    @ApiModelProperty("功能区类型名")
    private String deter2TypeName;
    @ApiModelProperty("功能区类型编号")
    private String deter2Type;

}
