package com.elitesland.yst.production.inv.application.out;

import com.alibaba.excel.util.CollectionUtils;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvUomQueryParamVO;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.item.dto.*;
import com.elitesland.yst.production.support.provider.item.param.*;
import com.elitesland.yst.production.support.provider.item.service.ItmBrandRpcService;
import com.elitesland.yst.production.support.provider.item.service.ItmItemRpcService;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;

/**
 * @Description: TODO
 * @Auther: menghua
 * @Date: 2021/5/8
 */
@Service
@AllArgsConstructor
@Slf4j
public class ItmOutServiceImpl implements ItmOutService {

    /**
     * 商品域新方法
     */

    private final ItmItemRpcService itemRpcService;
    /**
     * 商品域新方法
     */

    private final ItmBrandRpcService itmBrandRpcService;





    /**
     * 采购基础数据、采购价格、采购付款、供应商获取品牌全部信息接口查询
     *
     * @param param
     * @return
     */
    @Override
    public List<ItmItemRpcDTO> findItemRpcDtoByParam(ItmItemRpcDtoParam param) {
        log.info("调用支撑域商品中心商品查询方法开始,时间:{},参数:{}", LocalDateTime.now(), param);
        try {
            List<ItmItemRpcDTO> itmBrandAllDTOS = itemRpcService.findItemRpcDtoByParam(param);
            if (!CollectionUtils.isEmpty(itmBrandAllDTOS)) {
                return itmBrandAllDTOS;
            }
        } catch (Exception e) {
            log.error("调用支撑域商品查询方法失败:", e);
        }
        return Lists.newArrayList();
    }

    public boolean isAllFieldNull(Object o){
        boolean flag = true;
        Class clazz = o.getClass();
        Field[] fields = clazz.getDeclaredFields();

        for (Field field : fields){
            field.setAccessible(true);
            Object value = null;
            try {
                value = field.get(o);
                if(null != value){
                    flag = false;
                    break;
                }
            }catch (Exception e){
                log.error("检查对象非空异常:", e);
                e.printStackTrace();
            }
        }
        return flag;
    }

    public void excuteItemParam(ItmItemRpcDtoParam param){
        if(org.springframework.util.CollectionUtils.isEmpty(param.getItemIds())){
            param.setItemIds(null);
        }
        if(org.springframework.util.CollectionUtils.isEmpty(param.getSpuIds())){
            param.setSpuIds(null);
        }
        if(org.springframework.util.CollectionUtils.isEmpty(param.getSpuCodes())){
            param.setSpuCodes(null);
        }
        if(org.springframework.util.CollectionUtils.isEmpty(param.getItemCodes())){
            param.setItemCodes(null);
        }
        if(org.springframework.util.CollectionUtils.isEmpty(param.getSpecs())){
            param.setSpecs(null);
        }
        if(org.springframework.util.CollectionUtils.isEmpty(param.getBrands())){
            param.setBrands(null);
        }
        if(org.springframework.util.CollectionUtils.isEmpty(param.getSuppCodes())){
            param.setSuppCodes(null);
        }
        if(org.springframework.util.CollectionUtils.isEmpty(param.getItemSources())){
            param.setItemSources(null);
        }
        if(org.springframework.util.CollectionUtils.isEmpty(param.getSpuCode2s())){
            param.setSpuCode2s(null);
        }
    }

//    public boolean checkObjAllFieIsNull(Object o){
//        if(null == o){
//            return true;
//        }
//        try {
//            for(Field f : o.getClass().getDeclaredFields() ){
//                f.setAccessible(true);
//                if(f.get(0) != null && StringUtil.isNotBlank(f.get(o).toString())){
//                    return false;
//                }
//            }
//        }catch (Exception e){
//            log.error("检查对象非空异常:", e);
//            e.printStackTrace();
//        }
//        return true;
//    }

    @Override
    public List<Long> findItemIdByParam(ItmItemRpcDtoParam param) {
        log.info("调用支撑域商品中心商品查询方法开始,时间:{},参数:{}", LocalDateTime.now(), param);
        try {
            List<Long> itemIdByParam = itemRpcService.findItemIdByParam(param);
            if (!CollectionUtils.isEmpty(itemIdByParam)) {
                return itemIdByParam;
            }
        } catch (Exception e) {
            log.error("调用支撑域商品查询方法失败:", e);
        }
        return Lists.newArrayList();
    }

    @Override
    public  List<ItmItemUomConvRpcDTO> findItemUomConvDtoByParam(ItmItemUomConvRpcDtoParam param) {
        log.info("调用支撑域商品中心单位转换系数查询方法开始,时间:{},参数:{}", LocalDateTime.now(), param);
        try {
            List<ItmItemUomConvRpcDTO> uomConvRpcDTOS = itemRpcService.findItemUomConvDtoByParam(param);
            if (!CollectionUtils.isEmpty(uomConvRpcDTOS)) {
                return uomConvRpcDTOS;
            }
        } catch (Exception e){
            log.error("调用支撑域单位转换系数查询方法失败:", e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ItmBrandRpcDTO>  findItmBrandDtoByParam(ItmBrandRpcDtoParam param) {
        log.info("调用支撑域商品中心品牌查询方法开始,时间:{},参数:{}", LocalDateTime.now(), param);
        try {
            List<ItmBrandRpcDTO> brandDtoByParam = itmBrandRpcService.findBrandDtoByParam(param);
            if (!CollectionUtils.isEmpty(brandDtoByParam)) {
                return brandDtoByParam;
            }
        } catch (Exception e){
            log.error("调用支撑域商品中心品牌查询方法失败:", e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ItmItemBusinessRpcDTO> findItmItemBusinessByParam(ItmItemBusinessRpcDtoParam param) {
        log.info("调用支撑域商品中心findItmItemBusinessByParam方法开始,时间:{},参数:{}", LocalDateTime.now(), param);
        try {
            List<ItmItemBusinessRpcDTO> itmItemBusinessByParam = itemRpcService.findItmItemBusinessByParam(param);
            if (!CollectionUtils.isEmpty(itmItemBusinessByParam)) {
                return itmItemBusinessByParam;
            }
        } catch (Exception e){
            log.error("findItemUomConvDtoByParam error:", e);
        }
        return Lists.newArrayList();
    }

    @Override
    public Map<String, ItmCateCodeAndNameRpcDTO> findCateCodeReItemCateCode(ItmItemCateCodeParam param) {
        log.info("调用支撑域商品中心findCateCodeReItemCateCode方法开始,时间:{},参数:{}", LocalDateTime.now(), param);
        try {
            if(CollectionUtils.isEmpty(param.getItemCateCodes())){
                return null;
            }
            ItmItemCateCodeRpcDTO itemCateCode = itemRpcService.findCateCodeReItemCateCode(param);
            Map<String, ItmCateCodeAndNameRpcDTO> itemCateCodeCateMap = itemCateCode.getCateMap();
            return itemCateCodeCateMap;
        } catch (Exception e){
            log.error("调用支撑域商品中心根据品类编码查询方法失败:", e);
        }
        return null;
    }

    /**
     * 获得 商品单位转换率
     *
     * @param paramVO 商品code
     * @param paramVO 商品名称
     * @param paramVO 从单位
     * @param paramVO 至单位
     * @return 商品单位转换率
     * @Param uomConvRpcDTOS
     */
    @Override
    public BigDecimal getUomRatio(List<ItmItemUomConvRpcDTO> uomConvRpcDTOS, InvUomQueryParamVO paramVO) {
        log.info("单位转换参数为1：{},参数2：{}", uomConvRpcDTOS, paramVO);
        BigDecimal uomRatio = BigDecimal.ONE;
        if (paramVO.getFromUom() == null || paramVO.getToUom() == null || paramVO.getFromUom().equals(paramVO.getToUom())) {
            return uomRatio;
        }
     /*   ItmItemuomConvRatioQueryParm queryParm = new ItmItemuomConvRatioQueryParm();
        queryParm.setItemCode(paramVO.getItemCode());
        queryParm.setFromUom(paramVO.getFromUom());
        queryParm.setToUom(paramVO.getToUom());*/
        //商品单位转换
        Optional<ItmItemUomConvRpcDTO> convRpcDTO = uomConvRpcDTOS.stream().filter(u -> u.getItemId().equals(paramVO.getItemId())
                && u.getFromUom().equals(paramVO.getFromUom())
                && u.getToUom().equals(paramVO.getToUom())).findFirst();
        if (convRpcDTO.isPresent() && convRpcDTO.get().getRatio() != null) {
            if (convRpcDTO.get().getRatio().compareTo(BigDecimal.ZERO) <= 0) {
                throw new BusinessException(ApiCode.FAIL, "商品【" + paramVO.getItemCode() + "】单位转换" + paramVO.getFromUom() + "->" + paramVO.getToUom() + "异常,单位转换系数为0，请检查商品主数据");
            }
            return convRpcDTO.get().getRatio();
        } else{
            //商品单位转换
            Optional<ItmItemUomConvRpcDTO> convRpcDTO2 = uomConvRpcDTOS.stream().filter(u -> u.getItemId().equals(paramVO.getItemId())
                    && u.getFromUom().equals(paramVO.getToUom())
                    && u.getToUom().equals(paramVO.getFromUom())).findFirst();
            if(convRpcDTO2.isPresent() && convRpcDTO2.get().getRatio() != null){
                if (convRpcDTO2.get().getRatio().compareTo(BigDecimal.ZERO) <= 0) {
                    throw new BusinessException(ApiCode.FAIL, "商品【" + paramVO.getItemCode() + "】单位转换" + paramVO.getFromUom() + "->" + paramVO.getToUom() + "异常,单位转换系数为0，请检查商品主数据");
                }
                return convRpcDTO2.get().getRatio().negate();

            } else{
                throw new BusinessException(ApiCode.FAIL, "商品【" + paramVO.getItemCode() + "】单位转换" + paramVO.getFromUom() + "->" + paramVO.getToUom() + "异常，请检查商品主数据");
            }
        }
    }


}
