package com.elitesland.yst.production.inv.application.out;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.pur.dto.ss.PurSsDTO;
import com.elitesland.yst.production.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.yst.production.pur.dto.supp.PurSuppBaseRpcParam;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Optional;

public interface PurDubbleService {

    /**********************供应商OrgResp********************/
    /**
     * 模糊搜索供应商/客户/员工
     *
     * @param param code=code/name
     * @return 供应商/客户/员工的code和name
     */
    //  List<OrgRespVO> findcodeAndName(InvParentParamVO param);

    /**
     * 供应商查询
     *
     * @param param 供应商入参
     * @return 供应商结果
     */
    List<PurSuppBaseRpcDTO> findBaseRpcDtoByParam(PurSuppBaseRpcParam param);

    /**
     * 库存批次- 供应商查询
     *
     * @param suppIds 供应商id集
     * @return 供应商集
     */
    List<PurSuppBaseRpcDTO> findSuppByIdBatch(List<Long> suppIds);

    /**
     * 库存批次- 供应商查询
     *
     * @param code 供应商编码
     * @return 供应商集
     */
    Optional<PurSuppBaseRpcDTO> findSuppByCode(String code);

    /**
     * 库存批次- 供应商查询
     *
     * @param codes 供应商编码集合
     * @return 供应商集
     */
    List<PurSuppBaseRpcDTO> findSuppByCodeBatch(List<String> codes);

    void updateCarrierInfo(PurSsDTO param);

    void updateIsCarrige(PurSsDTO param);

}
