package com.elitesland.yst.production.inv.application.service;


import com.elitesland.yst.production.inv.application.facade.vo.*;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * @author lu.wang
 * @date 2020-08-12 08:25
 * Desc:
 */
public interface InvAsmDService {

    /**
     * 分页查询
     * @param param
     * @return
     */
    PagingVO<InvAsmAndAsmDRespVO> search(InvAsmAllQueryParam param);

    /**
     * 分页查询-组装单明细信息
     * @param param
     * @return
     */
    PagingVO<InvAsmAndAsmDRespVO> searchD(InvAsmAllQueryParam param);

    /**
     * 库存成本计算查询
     * @return
     */
    List<InvAsmDRespVO> listByCostCal(InvCalCostQueryParam param, int current, int PAGE_SIZE);

    /**
     * 组装单明细
     * @param param
     * @return
     */
    List<InvAsmAndAsmDRespVO> findAll(InvAsmAllQueryParam param);

//    List<Long> createInBatch(List<InvAsmDRespVO> list);

    /**
     * 批量删除明细行
     * @param ids
     * @return
     */
    int removeInBatch(List<Long> ids);

    /**
     * 提交确认
     * @param masId
     */
    void confirm(Long masId);

    /**
     * 审核通过
     * @param masId
     */
    void check(Long masId);

    /**
     * 审核拒绝
     * @param masId
     */
    void refuse(Long masId);

    List<InvAsmAndAsmDDownloadRespVO> outerNoAndOuterType(List<InvAsmAndAsmDRespVO> list);

}
