package com.elitesland.yst.production.inv.application.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.*;
import com.elitescloud.cloudt.common.base.PagingVO;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author liuqi
 * @since 2020-07-16 14:00:15
 */
public interface InvWhService {

    PagingVO<InvWhAreaRespVO> searchWhArea(InvWhAreaParamVO param);

    PagingVO<InvWhAreaRespVO> listWhArea(InvWhAreaParamVO param);

    Long createWh(InvWhSaveVO invWhSaveVO);

    Optional<InvWhRespVO> findWhAreaById(Long id);

    List<InvWhDeter2RespVO> findDeter2sByWhId(Long id);

    PagingVO<InvWhRespVO> search(InvWhParamVO param);

    List<InvWhRespVO> searchWhByParam(InvWhParamVO paramVO);

    List<InvWhRespVO> searchWhBaseByParam(InvWhParamVO paramVO);


    List<InvWhRespVO> findByCodes(List<String> codes);


    /**
     * 根据id集合查询
     * @param idList
     * @return
     */
    List<InvWhRespVO> findIdBatch(List<Long> idList);


    List<InvWhListRespVO> list(String keyword) throws ExecutionException, InterruptedException;

    /**
     * 删除
     *
     * @param idList 对象集合
     */
    void deleteBatch(List<Long> idList);

    List<InvWhRespVO> getDespatchWhByDeter2KeyWord(String deter2KeyWord);

    List<InvWhRespVO> findWhByIdBatch(List<Long> ids);

    List<InvWhRespVO> findWhByNameCode(String whNameCode);

}
