package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjDRespVO;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.domain.entity.InvAjDO;
import com.elitesland.yst.production.inv.domain.entity.QInvAjDO;
import com.elitesland.yst.production.inv.domain.service.InvAjDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvAjDomainService;
import com.elitesland.yst.production.inv.enums.InvStkSceneCodeEnum;
import com.elitesland.yst.production.inv.infr.dto.InvAjDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.infr.repo.InvAjRepo;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.application.service.InvAjProcessService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.*;

/**
 * @author lenovo
 * @version 1.0
 * @description: TODO
 * @date 2021/8/13 16:55
 */
@Service
@AllArgsConstructor
public class InvAjProcessServiceImpl implements InvAjProcessService {
    private final JPAQueryFactory jpaQueryFactory;
    private final InvAjRepo invAjRepo;
    private final InvAjDomainService invAjDomainService;
    private final InvAjDDomainService invAjDDomainService;
    private final SystemService systemService;
    private final InvStkOptBizService invStkOptBizService;



    @Override
    @Transactional
    public void processStatusChange(long id, ProcInstStatus procInstStatus) {
        //1,查询单据是否存在
        Optional<InvAjDO> invAjDO = invAjRepo.findById(id);
        if (invAjDO.isPresent() == false) {
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }

        QInvAjDO qInvAjDO = QInvAjDO.invAjDO;

        //2,修改审批状态
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qInvAjDO)
                .set(qInvAjDO.procInstStatus, procInstStatus)
                .where(qInvAjDO.id.eq(id));

        //3,修改单据状态
        switch (procInstStatus) {
            case NOTSUBMIT: // 未提交
            case INTERRUPT: // 中断执行PUR_PRI_STATUS_DL
                jpaUpdateClause.set(qInvAjDO.docStatus, UdcEnum.INV_AJ_STATUS_DR.getValueCode());//草稿
                break;
            case REJECTED: // 审批拒绝
                jpaUpdateClause.set(qInvAjDO.docStatus, UdcEnum.INV_AJ_STATUS_RJ.getValueCode());//拒绝
                break;
            case INVALID: // 作废
                jpaUpdateClause.set(qInvAjDO.docStatus, UdcEnum.INV_AJ_STATUS_CL.getValueCode());//取消
                break;
            case APPROVING: // 审批中
                jpaUpdateClause.set(qInvAjDO.docStatus, UdcEnum.INV_AJ_STATUS_APPING.getValueCode());//审批中(已提交)
                break;
            case APPROVED: // 审批通过
                jpaUpdateClause.set(qInvAjDO.docStatus, UdcEnum.INV_AJ_STATUS_APPED.getValueCode())//审批通过
                        .set(qInvAjDO.approvedTime, LocalDateTime.now())//审批完成时间
                ;
                break;
        }
        //执行
        jpaUpdateClause.execute();
        //4,审批拒绝后释放锁定量
        if(procInstStatus.equals(ProcInstStatus.APPROVED)) {
           //锁定库存
            //更新单据状态为完成
            InvAjDTO invAjDTO = invAjDomainService.findById(id);
            //库存操作对象
            if (UdcEnum.INV_AJ_TYPE_LOT.getValueCode().equals(invAjDTO.getDocType())
                    || UdcEnum.INV_AJ_TYPE_DES.getValueCode().equals(invAjDTO.getDocType())
                    || UdcEnum.INV_AJ_TYPE_STKOUT.getValueCode().equals(invAjDTO.getDocType()) ) {
                //增加库存锁定量
                this.stratLock(invAjDTO);
            }
        }
    }

    @Override
    @Transactional
    public ArrayList<String> taskAssignee(Long id, String customParams) {
        List<Long> userIds = systemService.findUserIdsByFlowRoles(id,customParams);
        ArrayList<String> userStrIds = new ArrayList<>();
        if(!CollectionUtils.isEmpty(userIds)) {
            userIds.stream().forEach( i -> {
                String newString = String.valueOf( i );
                userStrIds.add( newString );
            } );
            return userStrIds;
        }
        return null;
    }


    private void stratLock( InvAjDTO invAjDTO) {
        if (Objects.nonNull(invAjDTO)) {
            List<InvAjDRespVO> invAjDVOS = invAjDDomainService.findByMasId(invAjDTO.getId());
            //锁定
            InvStkCommonOperateDTO operateDTO = getInvStkCommonOperateDTO(invAjDVOS, invAjDTO, InvStkSceneCodeEnum.INV_AJ_AJ002.getType());
            invStkOptBizService.invStkCommonOperate(operateDTO);
        }
    }

    private InvStkCommonOperateDTO getInvStkCommonOperateDTO(List<InvAjDRespVO> invAjDRespVOS, InvAjDTO invAjDTO,String sceneCode) {
        InvStkCommonOperateDTO operateDTO = new InvStkCommonOperateDTO();
        operateDTO.setRequestId(UUID.randomUUID().toString().trim().replaceAll("-",""));
        operateDTO.setSceneCode(sceneCode);
        operateDTO.setSource("YST-INV");
        ArrayList<InvStkCommonOperateBodyDTO> operateBodyDTOS = new ArrayList<>();
        invAjDRespVOS.stream().forEach(invAjDSaveVO -> {
            InvStkCommonOperateBodyDTO operateBodyDTO = new InvStkCommonOperateBodyDTO();
            operateBodyDTO.setWhId(invAjDSaveVO.getWhId());
            operateBodyDTO.setItemId(invAjDSaveVO.getItemId());
            operateBodyDTO.setDeter2(invAjDSaveVO.getDeter2());
            operateBodyDTO.setSrcDocId(invAjDTO.getId());
            operateBodyDTO.setDocNo(invAjDTO.getDocNo());
            operateBodyDTO.setSrcDocDid(invAjDSaveVO.getId());
            operateBodyDTO.setSrcDocCls(UdcEnum.COM_DOC_CLS_STKOUT.getValueCode());
            operateBodyDTO.setLineNo(invAjDSaveVO.getLineNo());
            operateBodyDTO.setCreateUserId(invAjDTO.getCreateUserId());
            operateBodyDTO.setOpDate(LocalDateTime.now());
            operateBodyDTO.setUom(invAjDSaveVO.getUom());
            operateBodyDTO.setQty(invAjDSaveVO.getQty());
            operateBodyDTO.setLotNo(invAjDSaveVO.getLotNo());
            if(UdcEnum.INV_AJ_TYPE_STKIN.getValueCode().equals(invAjDTO.getDocType())
                    || UdcEnum.INV_AJ_TYPE_STKO.getValueCode().equals(invAjDTO.getDocType())){
                operateBodyDTO.setLotNo(invAjDSaveVO.getToLotNo());
            }
            operateBodyDTO.setPCode(invAjDSaveVO.getPCode());
            operateBodyDTO.setPType(invAjDSaveVO.getPType());
            operateBodyDTO.setOuId(invAjDTO.getOuId());
            operateBodyDTO.setVariId(invAjDSaveVO.getVariId());
            operateBodyDTOS.add(operateBodyDTO);
        });
        operateDTO.setSourceBodyList(operateBodyDTOS);
        return operateDTO;
    }
}
