package com.elitesland.yst.production.inv.application.service.stk.impl;

import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvSceneConfigBizService;
import com.elitesland.yst.production.inv.application.service.stk.InvStkOptBizService;
import com.elitesland.yst.production.inv.constants.InvRedisConstant;
import com.elitesland.yst.production.inv.constants.InvSysSettingConstant;
import com.elitesland.yst.production.inv.enums.WhetherEnum;
import com.elitesland.yst.production.inv.infr.dto.InvSceneConfigDTO;
import com.elitesland.yst.production.inv.infr.dto.InvSceneConfigDtlDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkQtyResultDTO;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.util.RedLockUtils;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.RedissonRedLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author Tom.su
 * @program yst-inv
 * @description
 * @date 2022/04/26 10:51
 */
@Service
@Slf4j
@NoArgsConstructor
public class InvStkOptBizServiceImpl implements InvStkOptBizService {
    @Autowired
    private InvSceneConfigBizService invSceneConfigBizService;
    @Autowired
    private RedLockUtils redLockUtils;

    @Autowired
    private SystemService systemService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<InvStkQtyResultDTO> invStkCommonOperate(@Valid InvStkCommonOperateDTO param)  {
        List<InvStkQtyResultDTO> resultList = new ArrayList<>();
        //校验库存帐卡配置，若未启用则不操作库存
        SysSettingVO sysSetting = systemService.findSysSetting(InvSysSettingConstant.SETTING_NO);
        if(sysSetting != null && InvSysSettingConstant.SETTING_VAL.equals(sysSetting.getSettingVal())){
            return resultList;
        }
        List<InvSceneConfigDtlDTO> configDtls = validateBusParam(param);
        RedissonRedLock rLock = redLockUtils.getRedLock(InvRedisConstant.INV_STK_COMMON_OPERATE + param.getRequestId());
        try{
            boolean lockFlag = rLock.tryLock(3, 60, TimeUnit.SECONDS);
            if (!lockFlag) {
                log.error("操作库存，获取锁失败...,请求流水号:{}", param.getRequestId());
                throw new BusinessException("请勿重复操作库存！请求流水号：" + param.getRequestId());
            }
            log.info("操作库存，加锁成功，来源系统:{},请求流水号:{},库存场景编码:{}", param.getSource(), param.getRequestId(), param.getSceneCode());
            //根据操作码集合编排
            for (InvSceneConfigDtlDTO configDtl : configDtls) {
                var optService = InvStkOptFactory.STK_OPT_SERVICE_HASH_MAP.get(configDtl.getIoType());
                if (optService == null) {
                    log.error("invStkCommonOperate 未找到相应的库存操作实现类" + configDtl.getIoType());
                    throw new BusinessException("invStkCommonOperate 未找到相应的库存操作实现类" + configDtl.getIoType());
                }
                if(UdcEnum.INV_OPT_TYPE_B.getValueCode().equals(configDtl.getWhoptType()) ){
                    if(CollectionUtils.isEmpty( param.getTargetBodyList())){
                        throw new BusinessException(ApiCode.FAIL,"目的库存操作明细参数为空，请检查");
                    }
                    resultList.addAll(optService.stkOperatePortal(configDtl,param.getSceneCode(), param.getTargetBodyList()));
                }else {//库存操作
                    resultList.addAll(optService.stkOperatePortal(configDtl, param.getSceneCode(),param.getSourceBodyList()));
                }
            }
        }catch (InterruptedException e){
            log.error("invStkCommonOperate InterruptedException,cause->", e);
            Thread.currentThread().interrupt();
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "系统线程中断！");
        }finally {
            rLock.unlock();
        }
        return resultList;
    }
    private List<InvSceneConfigDtlDTO> validateBusParam(InvStkCommonOperateDTO param) {
        if(StringUtils.isBlank(param.getSceneCode())){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "库存场景码不能为空!");
        }
        if(StringUtils.isBlank(param.getRequestId())){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "唯一请求ID不能为空!");
        }
        if(StringUtils.isBlank(param.getSource())){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "来源系统不能为空!");
        }
        if(CollectionUtils.isEmpty(param.getSourceBodyList())){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "要操作的库存明细不能为空!");
        }
        InvSceneConfigDTO sceneConfig = invSceneConfigBizService.getBySceneCode(param.getSceneCode());
        if(sceneConfig == null || CollectionUtils.isEmpty(sceneConfig.getInvSceneConfigDtlList())){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "未配置库存场景，请检查!");
        }
        if(!WhetherEnum.Y.name().equals(sceneConfig.getIsEnable())){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "该库存场景未启用，请检查!");
        }
        return sceneConfig.getInvSceneConfigDtlList().stream().sorted(Comparator.comparing(InvSceneConfigDtlDTO::getOptSeq,Comparator.nullsFirst(Integer::compareTo))).collect(Collectors.toList());
    }
}