package com.elitesland.yst.production.inv.application.web.controller;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.application.facade.vo.carr.InvCarrParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.carr.InvCarrRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.carr.InvCarrSaveVO;
import com.elitesland.yst.production.inv.application.service.InvCarrService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author feng
 * @program: yst-inv
 * @description: 承运商配送单
 * @date 2021-09-19 14:26:56
 */
@RestController
@RequestMapping("/invCarr")
@Api(value = "承运商配送单", tags = {"承运商配送单"})
@RequiredArgsConstructor
public class InvCarrController {
    private final InvCarrService invCarrService;

    @ApiOperation("保存配送单")
    @PostMapping("/save")
    public ApiResult<String> save(@RequestBody InvCarrSaveVO invCarrSaveVO){
        Long id = invCarrService.saveInvCarr(invCarrSaveVO,false);
        return ApiResult.ok(id.toString());
    }

    @ApiOperation("提交配送单")
    @PostMapping("/commit")
    public ApiResult<String> commit(@RequestBody InvCarrSaveVO invCarrSaveVO){
        Long id = invCarrService.saveInvCarr(invCarrSaveVO,true);
        return ApiResult.ok(id.toString());
    }

    @ApiOperation("详情")
    @GetMapping("/detail/{id}")
    public ApiResult<InvCarrRespVO> detail(@PathVariable Long id){
        return ApiResult.ok(invCarrService.detail(id));
    }

    @ApiOperation("配送单列表")
    @PostMapping("/list")
    public ApiResult<PagingVO<InvCarrRespVO>> list(@RequestBody InvCarrParamVO invCarrParamVO){
        return ApiResult.ok(invCarrService.list(invCarrParamVO));
    }

    @ApiOperation("删除")
    @DeleteMapping("/delete/{id}")
    public ApiResult delete(@PathVariable Long id){
        invCarrService.deleteInvCarr(id);
        return ApiResult.ok();
    }

    @ApiOperation("根据id集合提交")
    @PostMapping("/commitByIds")
    public ApiResult commitByIds(@RequestBody List<Long> ids){
        invCarrService.commitInvCarr(ids);
        return ApiResult.ok();
    }

}
