package com.elitesland.yst.production.inv.application.web.controller;

import com.elitesland.yst.production.inv.application.facade.vo.ck.*;

import com.elitesland.yst.production.inv.application.service.InvCkDService;
import com.elitesland.yst.production.inv.application.service.InvCkService;
import com.elitesland.yst.production.inv.utils.ExcelWriteUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;


/**
 * @author lvqf
 * @Date 2021/2/18
 * @Description 库存盘点
 */
@RestController
@RequestMapping("/invCk")
@Api(value = "库存盘点单", tags = {"库存盘点"})
@AllArgsConstructor
public class InvCkController {


    private final InvCkService invCkService;
    private final InvCkDService invCkDService;

    @PostMapping("/create")
    @ApiOperation("盘点单创建")
    public ApiResult create(@RequestBody InvCkCreateParamVO invCkCreateParamVO){
        invCkService.create(invCkCreateParamVO);
        return ApiResult.ok();
    }

    @PostMapping("/saveInvCkAndCkD")
    @ApiOperation("库存盘点保存/更新")
    public ApiResult saveInvCk(@RequestBody InvCkAndCkDSaveVO invCkAndCkDSaveVO){
        Long id = invCkService.saveOrSubmitInvCkAndCkD(invCkAndCkDSaveVO,false);
        return ApiResult.ok(id);
    }

    @PostMapping("/submitInvCk")
    @ApiOperation("库存盘点单提交")
    public ApiResult submitInvCk(@RequestBody InvCkAndCkDSaveVO invCkAndCkDSaveVO){
        Long id = invCkService.saveOrSubmitInvCkAndCkD(invCkAndCkDSaveVO,true);
        return ApiResult.ok(String.valueOf(id));
    }


    @PostMapping("/list")
    @ApiOperation("库存盘点列表查询")
    public ApiResult list(@RequestBody InvCkParamVO invCkParamVO){
        PagingVO<InvCkRespVO> list = invCkService.list(invCkParamVO);
        return ApiResult.ok(list);
    }

    @PutMapping("/approval/{id}")
    @ApiOperation("审批通过")
    public ApiResult approval(@PathVariable("id") Long id){
        invCkService.approval(id);
        return ApiResult.ok();
    }


    @PutMapping("/syncToInvAj/{id}")
    @ApiOperation("生成库存调整单")
    public ApiResult syncToInvAj(@PathVariable("id") Long id){
        invCkService.syncToInvAj(id);
        return ApiResult.ok();
    }


    @PutMapping("/reject/{id}")
    @ApiOperation("审批拒绝")
    public ApiResult reject(@PathVariable("id") Long id){
        invCkService.reject(id);
        return ApiResult.ok();
    }




    @GetMapping("/detail/{id}")
    @ApiOperation("盘点单详情")
    public ApiResult<InvCkAndCkDRespVO> detail(@PathVariable("id") Long id){
        return ApiResult.ok(invCkService.findInvCkAndCkDInfo(id));
    }


    @PutMapping("/cancelInvCk/{id}")
    @ApiOperation("取消")
    public ApiResult cancelInvCk(@PathVariable("id") Long id){
        invCkService.cancelInvCk(id);
        return ApiResult.ok();
    }

    /*@PostMapping("/exportInvCkList")
    @ApiOperation("库存盘点单列表导出")
    public void exportInvCkList(HttpServletResponse response, @RequestBody InvCkParamVO invCkParamVO) throws IOException {
        List<InvCkDownloadRespVO> invCkDownloadRespVOList = invCkService.findInvCkDownloadVOList(invCkParamVO);
        ExcelWriteUtil.excelWrite(response, invCkDownloadRespVOList, InvCkDownloadRespVO.class,"库存盘点单","库存盘点单");
    }*/
/*
    @GetMapping("/exportInvCkDList/{masId}")
    @ApiOperation("库存盘点单明细导出")
    public void exportInvCkDList(HttpServletResponse response,@PathVariable("masId") Long masId) throws IOException {
        List<InvCkDDownloadRespVO> invCkDDownloadRespVOList = invCkService.findInvCkDDownloadVOList(masId);
        ExcelWriteUtil.excelWrite(response, invCkDDownloadRespVOList, InvCkDDownloadRespVO.class,"库存盘点单明细","库存盘点单明细");
    }*/

  /*  @PostMapping("/exportInvCkDList2")
    @ApiOperation("库存盘点单明细导出v2")
    public void exportInvCkD2List(HttpServletResponse response, @RequestBody Map<String,String> masId) throws IOException {
        String masId1 = masId.get("masId");
        List<InvCkDExcelRespVO> invDCkDDownloadVOList2 = invCkService.findInvDCkDDownloadVOList2(Long.valueOf(masId1));
        ExcelWriteUtil.excelWriteDynamic(response, invDCkDDownloadVOList2, invCkService.head(), InvCkDExcelRespVO.class, "库存盘点单明细","库存盘点单明细");
    }*/

   /* @PostMapping("/importInvCkDList")
    @ApiOperation("库存盘点单明细导入")
    public ApiResult importInvCkDList(MultipartFile file){
        invCkDService.importInvCkDList(file);
        return ApiResult.ok();
    }*/



}
