package com.elitesland.yst.production.inv.application.web.controller;


import com.elitesland.yst.production.inv.application.facade.vo.lot.*;
import com.elitesland.yst.production.inv.application.service.InvLotCommonService;
import com.elitesland.yst.production.inv.application.service.InvLotService;
import com.elitesland.yst.production.inv.utils.ExcelWriteUtil;
import com.elitescloud.cloudt.common.base.ApiResult;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 批次主档
 * </p>
 *
 * @author ssy
 * @since 2020-07-30 15:07:56
 */
@RestController
@RequestMapping("/invLot")
@Api(value = "批次主档", tags = {"批次主档"})
@AllArgsConstructor
public class InvLotController {

    private final InvLotService invLotService;


    private final InvLotCommonService invLotCommonService;



    /**
     * 分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
    @PostMapping("/searchCombine")
    @ApiOperation("分页查询")
    public ApiResult<?> searchCombine(@RequestBody InvLotCombineParam param) {
        val ret = invLotService.findCombine(param);
        return ApiResult.ok(ret);
    }


    /**
     * 新增数据
     *
     * @param param 新增数据
     * @return 新增数据情况
     */
    @PostMapping("/createOne")
    @ApiOperation("新增数据")
    public ApiResult<?> createOne(@RequestBody InvLotSaveVO param) {
        List<InvLotSaveVO> list = new ArrayList<>();
        list.add(param);
       // return ApiResult.ok(invLotCommonService.createInvLotInfo(list));
        return invLotCommonService.createInvLotInfo(list);
    }


    @PostMapping("/searchD")
    @ApiOperation("详细数据查询")
    public ApiResult<?> searchD(@RequestBody InvStkDParam param) {
        val ret = invLotService.searchD(param);
        return ApiResult.ok(ret);
    }


    /**
     * 批量新增数据
     *
     * @param list 对象集合
     */
    @PostMapping("/createBatch")
    @ApiOperation("批量新增数据")
    public ApiResult<?> createBatch(@RequestBody List<InvLotSaveVO> list) {
        val dos = list.stream().map(i -> {
            InvLotSaveVO VO = new InvLotSaveVO();
            BeanUtils.copyProperties(i, VO);
            return VO;
        }).collect(Collectors.toList());
        return ApiResult.ok(invLotService.createBatch(dos));
    }


    /**
     * 修改数据
     *
     * @param param 修改对象
     * @return 修改数据详情
     */
    @PutMapping("/update")
    @ApiOperation("修改数据")
    public ApiResult<?> update(@RequestBody InvLotSaveVO param) {
        InvLotCommonSaveVO VO = new InvLotCommonSaveVO();
        BeanUtils.copyProperties(param, VO);
        List<InvLotCommonSaveVO> list = new ArrayList<InvLotCommonSaveVO>();
        list.add(VO);
       /* val ret = invLotCommonService.updateInvLotInfo(list);
        return ApiResult.ok(ret);*/
        return invLotCommonService.updateInvLotInfo(list);
    }



    /**
     * 查头信息
     *
     * @param id 查头信息
     */
    @GetMapping("/findheader/{id}")
    @ApiOperation("查头信息")
    public ApiResult<?> findInvLotAllOne(@PathVariable Long id) {
        val ret = invLotService.findInvLotAllOne(id);
        return ApiResult.ok(ret);
    }



    /**
     * 导出
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
   /* @PostMapping("/downloadCombine")
    @ApiOperation("批次导出")
    public void downloadCombine(HttpServletResponse response, @RequestBody InvLotCombineParam param) throws IOException {
        param.setSize(200000);
        val ret = invLotService.findCombine(param);
        List<InvLotRespVO> list = ret.getRecords();
        List<InvLotDownloadRespVO> collect = list.stream().map(i -> {
            InvLotDownloadRespVO downloadVO = new InvLotDownloadRespVO();
            downloadVO.setLotStatusName("1".equals(i.getLotStatus()) ? "是" : "否");
            BeanUtils.copyProperties(i, downloadVO);
            return downloadVO;
        }).collect(Collectors.toList());

        ExcelWriteUtil.excelWrite(response, collect, InvLotDownloadRespVO.class, "批次管理", "批次管理");
    }*/


    /**
     * 根据主键删除数据
     *
     * @param id 主键
     * @return 删除情况
     */
    @DeleteMapping("/deleteOne/{id}")
    @ApiOperation("根据主键删除数据")
    public ApiResult<?> deleteOne(@PathVariable Long id) {
        invLotService.deleteOne(id);
        return ApiResult.ok();
    }

    /**
     * 批量删除
     *
     * @param ids 删除数据集合
     */
    @DeleteMapping("/deleteBatch")
    @ApiOperation("批量删除")
    public ApiResult<?> deleteBatch(@RequestBody List<Long> ids) {
        invLotService.deleteBatch(ids);
        return ApiResult.ok();
    }

    /**
     * 逻辑删除
     *
     * @param id 更新数据
     */
    @PutMapping("/updateDeleteFlag/{id}")
    @ApiOperation("逻辑删除")
    public ApiResult<?> updateDeleteFlag(@PathVariable Long id) {
        invLotService.updateDeleteFlag(id);
        return ApiResult.ok();
    }

    /**
     * 根据关键字段查询数据
     *
     * @param key 参数
     * @return 数据
     */
   /* @GetMapping("/findCodeOne/{key}")
    @ApiOperation("根据关键字段查询数据")
    public ApiResult<?> findCodeOne(@PathVariable String key) {
        val vo = invLotService.findCodeOne(key);
        return vo.isPresent() ? ApiResult.ok(vo.get()) : ApiResult.ok();
    }*/


    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("/findIdOne/{id}")
    @ApiOperation("通过主键查询单条数据")
    public ApiResult<InvLotRespVO> findIdOne(@PathVariable Long id) {
        return invLotService.findLotById(id);
        //return vo.isPresent() ? ApiResult.ok(vo.get()) : ApiResult.ok();
    }


}
