package com.elitesland.yst.production.inv.application.web.controller;

import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingSaveVO;
import com.elitesland.yst.production.inv.application.service.InvWhAreaSettingService;
import com.elitesland.yst.production.inv.dto.invwh.InvWhAreaSettingRpcDTO;
import com.elitesland.yst.production.inv.provider.InvWhAreaSettingProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 功能说明:功能区配置
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/19
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping("/inv/whAreaSetting")
@Api(value = "功能区类型配置", tags = {"功能区类型配置"})
@AllArgsConstructor
public class InvWhAreaSettingController {

    private final InvWhAreaSettingService invWhAreaSettingService;

    private final InvWhAreaSettingProvider invWhAreaSettingProvider;


    /**
     * 新增功能区配置数据
     *
     * @param saveVo 新增功能区配置数据
     * @return 新增功能区配置ID
     */
    @PostMapping("/createOne")
    @ApiOperation("新增功能区类型配置数据")
    public ApiResult<Long> createOne(@RequestBody InvWhAreaSettingSaveVO saveVo) {
        return invWhAreaSettingService.createOne(saveVo);
    }

    /**
     * 修改功能区配置数据
     *
     * @param saveVo 修改功能区配置对象
     * @return 功能区配置ID
     */
    @PutMapping("/update")
    @ApiOperation("修改功能区类型配置数据")
    public ApiResult<Long> update(@RequestBody InvWhAreaSettingSaveVO saveVo) {
        return invWhAreaSettingService.update(saveVo);
    }

    /**
     * 通过功能区配置ID查询单条数据
     *
     * @param id 功能区配置ID
     * @return 单条功能区配置数据
     */
    @GetMapping("/findIdOne/{id}")
    @ApiOperation("通过功能区类型配置ID查询单条数据")
    public ApiResult<InvWhAreaSettingRespVO> findIdOne(@PathVariable Long id) {
        return invWhAreaSettingService.findIdOne(id);
    }

    @PostMapping("/test")
    @ApiOperation("通过功能区类型配置ID查询单条数据")
    public ApiResult<List<InvWhAreaSettingRpcDTO>> Test(@RequestBody List<String> deter2s) {
        List<InvWhAreaSettingRpcDTO> deter2List = invWhAreaSettingProvider.findDeter2List(deter2s);
        return ApiResult.ok(deter2List);
    }

    /**
     * 分页查询功能区配置
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条功能区配置数据
     */
    @PostMapping("/search")
    @ApiOperation("分页查询功能区类型配置")
    public ApiResult<PagingVO<InvWhAreaSettingRespVO>> search(@RequestBody InvWhAreaSettingParamVO param) {
        val ret = invWhAreaSettingService.search(param);
        return ApiResult.ok(ret);
    }

    /**
     * 根据功能区配置ID批量逻辑删除
     *
     * @param ids 功能区配置ID集合
     * @return 功能区配置ID集合
     */
    @DeleteMapping("/deleteBatch")
    @ApiOperation("根据功能区类型配置ID批量逻辑删除")
    public ApiResult<String> deleteBatch(@RequestBody List<Long> ids) {
        return invWhAreaSettingService.deleteBatch(ids);
    }

    @PostMapping("/findAllActives")
    @ApiOperation("查询所有生效的数据")
    public ApiResult<List<InvWhAreaSettingRespVO>> findAllActives(@RequestBody InvWhAreaSettingParamVO paramVO) {

        List<InvWhAreaSettingRespVO> allActives = invWhAreaSettingService.findAllActives(paramVO);
        return ApiResult.ok(allActives);
    }

}
