package com.elitesland.yst.production.inv.config;

import com.elitescloud.boot.swagger.common.BaseSwaggerConfig;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.spring.web.plugins.Docket;

/**
 * @author Jason(zhao jun hui)
 * @date 2021/3/27
 */
@Configuration
@ConditionalOnProperty(prefix = "knife4j", name = "enable", havingValue = "true")
public class InvSwaggerConfig extends BaseSwaggerConfig {

    public InvSwaggerConfig(OpenApiExtensionResolver openApiExtensionResolver, ServerProperties serverProperties) {
        super(openApiExtensionResolver, serverProperties);
    }

    @Bean
    public Docket createInvProductionRestApi() {
        return createDocket("库存中心[production]", "com.elitesland.yst.production.inv.application.web");
    }
}
