package com.elitesland.yst.production.inv.domain.entity;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author jeesie.jiang
 * @date 2022-03-30 15:58
 * Desc: 库内组装
 */
@Entity
@Table(name = "inv_asm")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "inv_asm", comment = "库内组装")
@Data
@Accessors(chain = true)
@ApiModel(value = "INV_ASM", description = "库内组装")
public class InvAsmDO extends BaseModel implements Serializable
{
    @ApiModelProperty("公司ID")
    @Column(name="ou_id" , columnDefinition = "bigint(20)  comment '公司ID'")
    Long ouId;

    @ApiModelProperty("BUID")
    @Column(name="bu_id" , columnDefinition = "bigint(20)  comment 'BUID'")
    Long buId;

    @ApiModelProperty("单据编号")
    @Column(name="doc_no" , columnDefinition = "varchar(40)  comment '单据编号'")
    String docNo;

    @ApiModelProperty("组装类型 [UDC]INV:ASM_TYPE")
    @Column(name="doc_type" , columnDefinition = "varchar(10)  comment '组装类型 [UDC]INV:ASM_TYPE'")
    String docType;

    @ApiModelProperty("组装单状态 [UDC]INV:ASM_STATUS")
    @Column(name="doc_status" , columnDefinition = "varchar(40)  comment '组装单状态 [UDC]INV:ASM_STATUS'")
    String docStatus;

    @ApiModelProperty("流程实例ID")
    @Column(name = "appr_proc_inst_id", columnDefinition = "varchar(40) default null  comment '流程实例ID'")
    String apprProcInstId;

    @ApiModelProperty("提审人ID")
    @Column(name = "appr_create_user_id", columnDefinition = "bigint default 0 comment '提审人ID'")
    Long apprCreateUserId;

    @ApiModelProperty("审批时间")
    @Column()
    @Comment("审批时间")
    LocalDateTime apprTime;

    @ApiModelProperty("审批人ID")
    @Column(name="appr_user_id" , columnDefinition = "bigint(20)  comment '审批人ID'")
    Long apprUserId;

    @ApiModelProperty("审批人名")
    @Column(name="appr_user_name" , columnDefinition = "varchar(64)  comment '审批人名'")
    String apprUserName;

    @ApiModelProperty("审批意见")
    @Column(name="appr_comment" , columnDefinition = "varchar(500)  comment '审批意见'")
    String apprComment;

    @ApiModelProperty("申请人员工ID")
    @Column(name="apply_emp_id" , columnDefinition = "bigint(20)  comment '申请人员工ID'")
    Long applyEmpId;

    @ApiModelProperty("申请日期")
    @Column()
    @Comment("申请日期")
    LocalDateTime applyDate;

    @ApiModelProperty("申请描述")
    @Column(name="apply_desc" , columnDefinition = "varchar(100)  comment '申请描述'")
    String applyDesc;

    @ApiModelProperty("交易日期 实际出入库日期")
    @Column()
    @Comment("申请日期")
    LocalDateTime ioDate;

    @ApiModelProperty("仓库ID")
    @Column(name="wh_id" , columnDefinition = "bigint(20)  comment '仓库ID'")
    Long whId;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @Column(name="deter1" , columnDefinition = "varchar(40)  comment '温层 [UDC]INV:TEMP_TYPE'")
    String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @Column(name="deter2" , columnDefinition = "varchar(40)  comment '功能区 [UDC]INV:FUNC_TYPE'")
    String deter2;

    @ApiModelProperty("客户标识")
    @Column(name="deter3" , columnDefinition = "varchar(40)  comment '客户标识'")
    String deter3;

    @ApiModelProperty("限定4")
    @Column(name="deter4" , columnDefinition = "varchar(40)  comment '限定4'")
    String deter4;

    @ApiModelProperty("限定5")
    @Column(name="deter5" , columnDefinition = "varchar(40)  comment '限定5'")
    String deter5;

    @ApiModelProperty("限定6")
    @Column(name="deter6" , columnDefinition = "varchar(40)  comment '限定6'")
    String deter6;

    @ApiModelProperty("限定7")
    @Column(name="deter7" , columnDefinition = "varchar(40)  comment '限定7'")
    String deter7;

    @ApiModelProperty("限定8")
    @Column(name="deter8" , columnDefinition = "varchar(40)  comment '限定8'")
    String deter8;

    @ApiModelProperty("税额")
    @Column(name="tax_amt" , columnDefinition = "NUMERIC(20,4)   comment '税额'")
    BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    @Column(name="amt" , columnDefinition = "NUMERIC(20,4)   comment '含税金额'")
    BigDecimal amt;

    @ApiModelProperty("不含税金额")
    @Column(name="net_amt" , columnDefinition = "NUMERIC(20,4)   comment '不含税金额'")
    BigDecimal netAmt;

    @ApiModelProperty("记账币种")
    @Column(name="home_curr" , columnDefinition = "varchar(10)  comment '记账币种'")
    String homeCurr;

    @ApiModelProperty("交易币种")
    @Column(name="curr_code" , columnDefinition = "varchar(10)  comment '交易币种'")
    String currCode;

    @ApiModelProperty("汇率")
    @Column(name="curr_rate" , columnDefinition = "float(20,8)   comment '汇率'")
    Float currRate;

    @ApiModelProperty("外币不含税金额")
    @Column(name="curr_net_amt" , columnDefinition = "NUMERIC(20,4)   comment '外币不含税金额'")
    BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    @Column(name="curr_amt" , columnDefinition = "NUMERIC(20,4)   comment '外币含税金额'")
    BigDecimal currAmt;

    @ApiModelProperty("成本金额")
    @Column(name="cost_amt" , columnDefinition = "NUMERIC(20,4)   comment '成本金额'")
    BigDecimal costAmt;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    @Column(name="reason_code" , columnDefinition = "varchar(40)  comment '原因码 [UDC]COM:REASON_CODE'")
    String reasonCode;

    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    @Column(name="relate_doc_cls" , columnDefinition = "varchar(40)  comment '关联单据类别 [UDC]COM:DOC_CLS'")
    String relateDocCls;

    @ApiModelProperty("关联单据类型")
    @Column(name="relate_doc_type" , columnDefinition = "varchar(40)  comment '关联单据类型'")
    String relateDocType;

    @ApiModelProperty("关联单据ID")
    @Column(name="relate_doc_id" , columnDefinition = "bigint(20)  comment '关联单据ID'")
    Long relateDocId;

    @ApiModelProperty("关联单据编号")
    @Column(name="relate_doc_no" , columnDefinition = "varchar(40)  comment '关联单据编号'")
    String relateDocNo;

    @ApiModelProperty("关联ID")
    @Column(name="relate_id" , columnDefinition = "bigint(20)  comment '关联ID'")
    Long relateId;

    @ApiModelProperty("关联编号")
    @Column(name="relate_no" , columnDefinition = "varchar(40)  comment '关联编号'")
    String relateNo;

    @ApiModelProperty("关联2ID")
    @Column(name="relate2_id" , columnDefinition = "bigint(20)  comment '关联2ID'")
    Long relate2Id;

    @ApiModelProperty("关联2编号")
    @Column(name="relate2_no" , columnDefinition = "varchar(40)  comment '关联2编号'")
    String relate2No;

    @ApiModelProperty("原因码 [UDC]COM:APPR_STATUS")
    @Column(name="doc_reason" , columnDefinition = "varchar(10)  comment '原因码 [UDC]COM:APPR_STATUS'")
    String docReason;

    @ApiModelProperty("是否走接口")
    @Column(name="intf_flag" , columnDefinition = " int(1)   comment '是否走接口'")
    Integer intfFlag;

    @ApiModelProperty("ES1")
    @Column(name="es1" , columnDefinition = "varchar(40)  comment 'ES1'")
    String es1;

    @ApiModelProperty("ES2")
    @Column(name="es2" , columnDefinition = "varchar(40)  comment 'ES2'")
    String es2;

    @ApiModelProperty("ES3")
    @Column(name="es3" , columnDefinition = "varchar(40)  comment 'ES3'")
    String es3;

    @ApiModelProperty("ES4")
    @Column(name="es4" , columnDefinition = "varchar(40)  comment 'ES4'")
    String es4;

    @ApiModelProperty("ES5")
    @Column(name="es5" , columnDefinition = "varchar(40)  comment 'ES5'")
    String es5;

    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    @Column
    @Comment("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    @Column
    @Comment("流程实例状态")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @ApiModelProperty(value = "提交时间")
    @Comment("提交时间")
    @Column
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    @Comment("审批通过时间")
    @Column
    private LocalDateTime approvedTime;

    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    @Column(name="appr_status" , columnDefinition = "varchar(40)  comment '审批状态 [UDC]COM:APPR_STATUS'")
    String apprStatus;

    @ApiModelProperty("单据类别")
    @Column(name = "doc_cls", columnDefinition = "varchar(40)  comment '单据类别'")
    String docCls;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvAsmDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvAsmDO entity = (InvAsmDO) o;
        return getId().equals(entity.getId());
    }
    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
