package com.elitesland.yst.production.inv.domain.entity.carr;


import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 承运商配送单
 */
@Entity
@Table(name = "inv_carr")
@DynamicInsert
@org.hibernate.annotations.Table(appliesTo = "inv_carr", comment = "承运商配送单")
@Data
@Accessors(chain = true)
@ApiModel(value = "inv_carr", description = "承运商配送单")
public class InvCarrDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 4351290079825015747L;
    @ApiModelProperty("公司ID")
    @Column(name="ou_id" , columnDefinition = "bigint default 0  comment '公司ID'")
    Long ouId;

    @ApiModelProperty("BUID")
    @Column(name="bu_id" , columnDefinition = "bigint default 0  comment 'BUID'")
    Long buId;

    @ApiModelProperty("单据编号")
    @Column(name="doc_no" , columnDefinition = "varchar(40)  comment '单据编号'")
    String docNo;

    @ApiModelProperty("单据类型 [UDC]INV:CARR_STATUS")
    @Column(name="doc_type" , columnDefinition = "varchar(10)  comment '单据类型 [UDC]INV:CARR_TYPE'")
    String docType;

    @ApiModelProperty("单据状态 [UDC]INV:CARR_STATUS")
    @Column(name="doc_status" , columnDefinition = "varchar(40)  comment '单据状态 [UDC]INV:CARR_STATUS'")
    String docStatus;

    @ApiModelProperty("收货总数")
    @Column(name="qty" , columnDefinition = "NUMERIC(20,2)   comment '收货总数'")
    BigDecimal qty;

    @ApiModelProperty("发货日期")
    @Column(name="shipment_date" , columnDefinition = "datetime   comment '发货日期'")
    LocalDateTime shipmentDate;

    @ApiModelProperty("采购订单ID")
    @Column(name="po_id" , columnDefinition = "bigint default 0  comment '采购订单ID'")
    Long poId;

    @ApiModelProperty("供应商ID")
    @Column(name="supp_id" , columnDefinition = "bigint default 0  comment '供应商ID'")
    Long suppId;

    @ApiModelProperty("承运商ID")
    @Column(name="carrier_supp_id" , columnDefinition = "bigint default 0  comment '承运商ID'")
    Long carrierSuppId;

    @ApiModelProperty("承运商编码")
    @Column(name="carrier_supp_code" , columnDefinition = "varchar(20)  comment '承运商编码'")
    String carrierSuppCode;

    @ApiModelProperty("供应商发货单号")
    @Column(name="supp_doc_no" , columnDefinition = "varchar(64)  comment '供应商发货单号'")
    String suppDocNo;

    @ApiModelProperty("越库标识")
    @Column(name="crosswh_flag" , columnDefinition = "int(16)  comment '越库标识'")
    Integer crosswhFlag;

    @ApiModelProperty("仓库ID")
    @Column(name="wh_id" , columnDefinition = "bigint default 0  comment '仓库ID'")
    Long whId;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @Column(name="deter1" , columnDefinition = "varchar(64)  comment '温层 [UDC]INV:TEMP_TYPE'")
    String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @Column(name="deter2" , columnDefinition = "varchar(64)  comment '功能区 [UDC]INV:FUNC_TYPE'")
    String deter2;

    @ApiModelProperty("客户标识")
    @Column(name="deter3" , columnDefinition = "varchar(64)  comment '客户标识'")
    String deter3;

    @ApiModelProperty("限定4")
    @Column(name="deter4" , columnDefinition = "varchar(64)  comment '限定4'")
    String deter4;

    @ApiModelProperty("限定5")
    @Column(name="deter5" , columnDefinition = "varchar(64)  comment '限定5'")
    String deter5;

    @ApiModelProperty("限定6")
    @Column(name="deter6" , columnDefinition = "varchar(64)  comment '限定6'")
    String deter6;

    @ApiModelProperty("限定7")
    @Column(name="deter7" , columnDefinition = "varchar(64)  comment '限定7'")
    String deter7;

    @ApiModelProperty("限定8")
    @Column(name="deter8" , columnDefinition = "varchar(64)  comment '限定8'")
    String deter8;

    @ApiModelProperty("库位")
    @Column(name="wh_loc" , columnDefinition = "varchar(64)  comment '库位'")
    String whLoc;

    @ApiModelProperty("货位")
    @Column(name="wh_posi" , columnDefinition = "varchar(64)  comment '货位'")
    String whPosi;

    @ApiModelProperty("预计到货日期")
    @Column(name="eta_date" , columnDefinition = "datetime   comment '预计到货日期'")
    LocalDateTime etaDate;

    @ApiModelProperty("发运联系人")
    @Column(name="shipment_contact_name" , columnDefinition = "varchar(40)  comment '发运联系人'")
    String shipmentContactName;

    @ApiModelProperty("发运详细地址")
    @Column(name="shipment_detailaddr" , columnDefinition = "varchar(60)  comment '发运详细地址'")
    String shipmentDetailAddr;

    @ApiModelProperty("发运联系电话")
    @Column(name="shipment_contact_tel" , columnDefinition = "varchar(40)  comment '发运联系电话'")
    String shipmentContactTel;

    @ApiModelProperty("拒收原因")
    @Column(name="reject_reason" , columnDefinition = "varchar(64)  comment '拒收原因'")
    String rejectReason;

    @ApiModelProperty("拒收时间")
    @Column(name="reject_time" , columnDefinition = "datetime   comment '拒收时间'")
    LocalDateTime rejectTime;

    @ApiModelProperty("根ID")
    @Column(name="root_id" , columnDefinition = "bigint default 0  comment '根ID'")
    Long rootId;

    @ApiModelProperty("来源单据类别 [UDC]COM:DOC_CLS")
    @Column(name="root_doc_cls" , columnDefinition = "varchar(64)  comment '来源单据类别 [UDC]COM:DOC_CLS'")
    String rootDocCls;

    @ApiModelProperty("来源单据类型")
    @Column(name="root_doc_type" , columnDefinition = "varchar(64)  comment '来源单据类型'")
    String rootDocType;

    @ApiModelProperty("来源单据Id")
    @Column(name="root_doc_id" , columnDefinition = "bigint default 0   comment '来源单据Id'")
    Long rootDocId;

    @ApiModelProperty("来源单据编号")
    @Column(name="root_doc_no" , columnDefinition = "varchar(64)  comment '来源单据编号'")
    String rootDocNo;

    @ApiModelProperty("外部单据公司")
    @Column(name = "outer_ou", columnDefinition = "varchar(40)  comment '外部单据公司'")
    String outerOu;

    @ApiModelProperty("外部单据类型")
    @Column(name = "outer_type", columnDefinition = "varchar(40)  comment '外部单据类型'")
    String outerType;

    @ApiModelProperty("外部单据编号")
    @Column(name = "outer_no", columnDefinition = "varchar(40)  comment '外部单据编号'")
    String outerNo;

    @ApiModelProperty("外部单据编号Id")
    @Column(name = "outer_id", columnDefinition = "bigint default 0  comment '外部单据编号Id'")
    Long outerId;

    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    @Column(name="relate_doc_cls" , columnDefinition = "varchar(64)  comment '关联单据类别 [UDC]COM:DOC_CLS'")
    String relateDocCls;

    @ApiModelProperty("关联单据类型")
    @Column(name="relate_doc_type" , columnDefinition = "varchar(64)  comment '关联单据类型'")
    String relateDocType;

    @ApiModelProperty("关联单据ID")
    @Column(name="relate_doc_id" , columnDefinition = "bigint default 0  comment '关联单据ID'")
    Long relateDocId;

    @ApiModelProperty("关联单据编号")
    @Column(name="relate_doc_no" , columnDefinition = "varchar(64)  comment '关联单据编号'")
    String relateDocNo;

    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    @Column(name="relate_doc2_cls" , columnDefinition = "varchar(64)  comment '关联单据2类别 [UDC]COM:DOC_CLS'")
    String relateDoc2Cls;

    @ApiModelProperty("关联单据2类型")
    @Column(name="relate_doc2_type" , columnDefinition = "varchar(64)  comment '关联单据2类型'")
    String relateDoc2Type;

    @ApiModelProperty("关联单据2ID")
    @Column(name="relate_doc2_id" , columnDefinition = "bigint default 0  comment '关联单据2ID'")
    Long relateDoc2Id;

    @ApiModelProperty("关联单据2编号")
    @Column(name="relate_doc2_no" , columnDefinition = "varchar(64)  comment '关联单据2编号'")
    String relateDoc2No;

    @ApiModelProperty("关联ID")
    @Column(name="relate_id" , columnDefinition = "bigint default 0  comment '关联ID'")
    Long relateId;

    @ApiModelProperty("关联编号")
    @Column(name="relate_no" , columnDefinition = "varchar(64)  comment '关联编号'")
    String relateNo;

    @ApiModelProperty("关联2ID")
    @Column(name="relate2_id" , columnDefinition = "bigint default 0  comment '关联2ID'")
    Long relate2Id;

    @ApiModelProperty("关联2编号")
    @Column(name="relate2_no" , columnDefinition = "varchar(64)  comment '关联2编号'")
    String relate2No;

    @ApiModelProperty("ES1")
    @Column(name="es1" , columnDefinition = "varchar(64)  comment 'ES1'")
    String es1;

    @ApiModelProperty("ES2")
    @Column(name="es2" , columnDefinition = "varchar(64)  comment 'ES2'")
    String es2;

    @ApiModelProperty("ES3")
    @Column(name="es3" , columnDefinition = "varchar(64)  comment 'ES3'")
    String es3;

    @ApiModelProperty("ES4")
    @Column(name="es4" , columnDefinition = "varchar(64)  comment 'ES4'")
    String es4;

    @ApiModelProperty("ES5")
    @Column(name="es5" , columnDefinition = "varchar(64)  comment 'ES5'")
    String es5;

    @ApiModelProperty("收货地址")
    @Column(name="recv_addr" , columnDefinition = "varchar(200)  comment '收货地址'")
    String recvAddr;

    @ApiModelProperty("本币币种")
    @Column(name="home_curr" , columnDefinition = "varchar(40)  comment '本币币种'")
    String homeCurr;

    @ApiModelProperty("币种")
    @Column(name="curr_code" , columnDefinition = "varchar(40)  comment '币种'")
    String currCode;

    @ApiModelProperty("汇率")
    @Column(name="curr_rate" , columnDefinition = "NUMERIC(20,8)   comment '汇率'")
    BigDecimal currRate;

    @ApiModelProperty("是否含税")
    @Column(name="tax_incl_flag" , columnDefinition = " int(1)   comment '是否含税'")
    Integer taxInclFlag;

    @ApiModelProperty("税码")
    @Column(name="tax_code" , columnDefinition = "varchar(40)  comment '税码'")
    String taxCode;

    @ApiModelProperty("税率编号")
    @Column(name="tax_rate_no" , columnDefinition = "varchar(40)  comment '税率编号'")
    String taxRateNo;

    @ApiModelProperty("税率")
    @Column(name="tax_rate" , columnDefinition = "NUMERIC(20,8)   comment '税率'")
    BigDecimal taxRate;

    @ApiModelProperty("税额")
    @Column(name="tax_amt" , columnDefinition = "NUMERIC(20,2)   comment '税额'")
    BigDecimal taxAmt;

    @ApiModelProperty("含税总金额")
    @Column(name="amt" , columnDefinition = "NUMERIC(20,2)   comment '含税总金额'")
    BigDecimal amt;

    @ApiModelProperty("未税总金额")
    @Column(name="net_amt" , columnDefinition = "NUMERIC(20,2)   comment '未税总金额'")
    BigDecimal netAmt;

    @ApiModelProperty("外币不含税金额")
    @Column(name="curr_net_amt" , columnDefinition = "NUMERIC(20,2)   comment '外币不含税金额'")
    BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    @Column(name="curr_amt" , columnDefinition = "NUMERIC(20,2)   comment '外币含税金额'")
    BigDecimal currAmt;

    @ApiModelProperty("是否有接口0:无接口,1:有接口")
    @Column(name="intf_flag" , columnDefinition = "TINYINT(2)   comment '是否有接口0:无接口,1:有接口'")
    Integer intfFlag;

    @ApiModelProperty("收货人员工ID")
    @Column(name = "recv_emp_id", columnDefinition = "bigint default 0  comment '收货人员工ID'")
    Long recvEmpId;

    @ApiModelProperty("收货人名字")
    @Column(name = "recv_emp_name", columnDefinition = "varchar(40) comment '收货人员工名字'")
    String recvEmpName;

    @ApiModelProperty("联系人电话")
    @Column(name = "tel", columnDefinition = "varchar(40) comment '联系人电话'")
    String tel;

    @ApiModelProperty("地址")
    @Column(name = "detail_addr", columnDefinition = "varchar(40) comment '地址'")
    String detailAddr;

    @ApiModelProperty("已收数量")
    @Column(name="accept_qty" , columnDefinition = "NUMERIC(20,8)   comment '已收数量'")
    BigDecimal acceptQty;
    @ApiModelProperty("快递公司编号")
    @Column(name = "logistics_ou_code", columnDefinition = "varchar(25)   comment '快递公司编号'")
    private String logisticsOuCode;

    @ApiModelProperty("物流单号")
    @Column(name = "logistics_doc_no", columnDefinition = "varchar(30)   comment '物流单号'")
    private String logisticsDocNo;

    @ApiModelProperty("车号")
    @Column(name = "car_number", columnDefinition = "varchar(30)   comment '车号'")
    private String carNumber;

    @ApiModelProperty("司机")
    @Column(name = "driver", columnDefinition = "varchar(20)   comment '司机'")
    private String driver;

    @ApiModelProperty("司机电话")
    @Column(name = "driver_phone", columnDefinition = "varchar(15)   comment '司机电话'")
    private String driverPhone;

    @ApiModelProperty("包装数量")
    @Column(name = "packing_qty", columnDefinition = "varchar(15)   comment '包装数量'")
    private String packingQty;

    @ApiModelProperty("总重量")
    @Column(name = "total_weight", columnDefinition = "varchar(15)   comment '总重量'")
    private String totalWeight;

    @ApiModelProperty("物流备注")
    @Column(name = "logistics_remark", columnDefinition = "varchar(30)   comment '物流备注'")
    private String logisticsRemark;

    @ApiModelProperty("文件服务器编码")
    @Column(name = "file_code", columnDefinition = "varchar(2000)  comment '文件服务器编码'")
    private String fileCode;

    @ApiModelProperty("配送日期")
    @Column(name="delivery_date" , columnDefinition = "datetime   comment '配送日期'")
    private LocalDateTime deliveryDate;

    @ApiModelProperty("承运商联系人")
    @Column(name = "carrier_contact_name", columnDefinition = "varchar(20) comment '承运商联系人'")
    private String carrierContactName;

    @ApiModelProperty("承运商联系电话")
    @Column(name = "carrier_contact_tel", columnDefinition = "varchar(15) comment '承运商联系电话'")
    private String carrierContactTel;

}
