package com.elitesland.yst.production.inv.domain.service;


import com.elitesland.yst.production.inv.application.facade.vo.*;
import com.elitesland.yst.production.inv.domain.entity.InvAsmD;
import com.elitesland.yst.production.inv.domain.entity.InvAsmDDO;
import com.elitesland.yst.production.inv.infr.dto.InvAsmAndAsmDDTO;
import com.elitesland.yst.production.inv.infr.dto.InvAsmDTO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * @author lu.wang
 * @date 2020-08-12 08:25
 * Desc:
 */
public interface InvAsmDDomainService {

    /**
     * 分页查询
     * @param param
     * @return
     */
    PagingVO<InvAsmAndAsmDDTO> search(InvAsmAllQueryParam param);

    void deleteBatch(List<Long> list);



    void createBatch(List<InvAsmD> invAsmDList);


    /**
     * 库存成本计算查询
     * @return
     */
    List<InvAsmDRespVO> listByCostCal(InvCalCostQueryParam param, int current, int PAGE_SIZE);

    /**
     * 组装单明细
     * @param param
     * @return
     */
    List<InvAsmAndAsmDDTO> findAll(InvAsmAllQueryParam param);

//    List<Long> createInBatch(List<InvAsmDRespVO> list);

    /**
     * 批量删除明细行
     * @param ids
     * @return
     */
    int removeInBatch(List<Long> ids);

    List<InvAsmDDO>findByMasId(Long masId);




}
