package com.elitesland.yst.production.inv.domain.service;

import com.elitesland.yst.production.inv.domain.entity.ck.InvCkD;
import com.elitesland.yst.production.inv.infr.dto.ck.InvCkDDTO;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/14
 * @Version 1.0
 * @Content:
 */
public interface InvCkdDomainService {

    /**
     * 库存盘点明细保存
     *
     * @param invCkD
     * @return
     */
    Long saveInvCkD(InvCkD invCkD);

    /**
     * 库存盘点明细批量保存
     *
     * @param invCkDList
     * @return
     */
    List<Long> saveInvCkDList(List<InvCkD> invCkDList);

    /**
     * 根据主表ID删除库存盘点明细
     *
     * @param id
     * @return
     */
    void deleteByMasId(Long id);

    /**
     * 根据主表ID批量删除库存盘点明细
     *
     * @param idList
     * @return
     */
    void deleteByMasIdBatch(List<Long> idList);

    /**
     * 根据主表ID查询库存盘点明细
     *
     * @param masId
     * @return
     */
    List<InvCkDDTO> selectByMasId(Long masId);

    List<InvCkDDTO> selectByDeter2KeyWords(String deter2KeyWords);
}
